<?php
require_once __DIR__ . '/config.php';
$pageTitle = 'Changelog - ' . APP_NAME;
$currentPage = 'changelog';

require_once __DIR__ . '/includes/header.php';
requireLogin();

$db = getDB();

$entityType = $_GET['entity_type'] ?? '';
$action = $_GET['action'] ?? '';
$page = max(1, (int)($_GET['page'] ?? 1));
$perPage = 50;

$where = [];
$params = [];

if ($entityType) { $where[] = "entity_type = ?"; $params[] = $entityType; }
if ($action) { $where[] = "action = ?"; $params[] = $action; }

$whereClause = $where ? 'WHERE ' . implode(' AND ', $where) : '';

$stmt = $db->prepare("SELECT COUNT(*) FROM changelog {$whereClause}");
$stmt->execute($params);
$total = $stmt->fetchColumn();

$pagination = paginate($total, $perPage, $page);

$sql = "SELECT c.*, a.name as admin_name FROM changelog c LEFT JOIN admins a ON c.admin_id = a.id {$whereClause} ORDER BY c.created_at DESC LIMIT {$pagination['per_page']} OFFSET {$pagination['offset']}";
$stmt = $db->prepare($sql);
$stmt->execute($params);
$logs = $stmt->fetchAll();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4><i class="bi bi-clock-history me-2"></i>Changelog</h4>
    <span class="text-muted">Ukupno <?= $total ?> zapisa</span>
</div>

<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-4">
                <select name="entity_type" class="form-select">
                    <option value="">Svi tipovi</option>
                    <option value="server" <?= $entityType === 'server' ? 'selected' : '' ?>>Serveri</option>
                    <option value="vm" <?= $entityType === 'vm' ? 'selected' : '' ?>>Virtualke</option>
                    <option value="user" <?= $entityType === 'user' ? 'selected' : '' ?>>Korisnici</option>
                    <option value="printer" <?= $entityType === 'printer' ? 'selected' : '' ?>>Printeri</option>
                    <option value="license" <?= $entityType === 'license' ? 'selected' : '' ?>>Licencije</option>
                </select>
            </div>
            <div class="col-md-4">
                <select name="action" class="form-select">
                    <option value="">Sve akcije</option>
                    <option value="create" <?= $action === 'create' ? 'selected' : '' ?>>Create</option>
                    <option value="update" <?= $action === 'update' ? 'selected' : '' ?>>Update</option>
                    <option value="delete" <?= $action === 'delete' ? 'selected' : '' ?>>Delete</option>
                </select>
            </div>
            <div class="col-md-4">
                <button type="submit" class="btn btn-outline-secondary">Filtriraj</button>
                <a href="changelog.php" class="btn btn-outline-secondary">Reset</a>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>Vrijeme</th>
                    <th>Korisnik</th>
                    <th>Akcija</th>
                    <th>Tip</th>
                    <th>Entitet</th>
                    <th>IP</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($logs)): ?>
                <tr><td colspan="6" class="text-center text-muted py-4">Nema zapisa</td></tr>
                <?php else: ?>
                <?php foreach ($logs as $log): ?>
                <tr>
                    <td><?= formatDateTime($log['created_at']) ?></td>
                    <td><?= clean($log['admin_name'] ?? 'System') ?></td>
                    <td>
                        <span class="badge bg-<?= match($log['action']) { 'create' => 'success', 'update' => 'primary', 'delete' => 'danger', default => 'secondary' } ?>"><?= ucfirst($log['action']) ?></span>
                    </td>
                    <td><span class="badge bg-secondary"><?= ucfirst($log['entity_type']) ?></span></td>
                    <td><?= clean($log['entity_name']) ?></td>
                    <td><small class="text-muted"><?= clean($log['ip_address']) ?></small></td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    
    <?php if ($pagination['total_pages'] > 1): ?>
    <div class="card-footer">
        <nav>
            <ul class="pagination justify-content-center mb-0">
                <?php if ($pagination['has_prev']): ?>
                <li class="page-item"><a class="page-link" href="?page=<?= $pagination['current_page'] - 1 ?>&entity_type=<?= $entityType ?>&action=<?= $action ?>">«</a></li>
                <?php endif; ?>
                <?php for ($i = max(1, $pagination['current_page'] - 2); $i <= min($pagination['total_pages'], $pagination['current_page'] + 2); $i++): ?>
                <li class="page-item <?= $i === $pagination['current_page'] ? 'active' : '' ?>"><a class="page-link" href="?page=<?= $i ?>&entity_type=<?= $entityType ?>&action=<?= $action ?>"><?= $i ?></a></li>
                <?php endfor; ?>
                <?php if ($pagination['has_next']): ?>
                <li class="page-item"><a class="page-link" href="?page=<?= $pagination['current_page'] + 1 ?>&entity_type=<?= $entityType ?>&action=<?= $action ?>">»</a></li>
                <?php endif; ?>
            </ul>
        </nav>
    </div>
    <?php endif; ?>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
