<?php
require_once __DIR__ . '/../config.php';
if (session_status() === PHP_SESSION_NONE) {
    session_name(SESSION_NAME);
    session_start();
}
require_once __DIR__ . '/functions.php';
require_once __DIR__ . '/auth.php';
?>
<!DOCTYPE html>
<html lang="hr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?? APP_NAME ?></title>
    
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Bootstrap & Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    
    <!-- Custom CSS -->
    <link href="<?= APP_URL ?>/assets/css/style.css" rel="stylesheet">
</head>
<body>
<?php if (isLoggedIn()): ?>
<nav class="navbar navbar-expand-lg">
    <div class="container-fluid">
        <a class="navbar-brand" href="<?= APP_URL ?>">
            <i class="bi bi-hdd-rack"></i>
            <span><?= APP_NAME ?></span>
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav me-auto">
                <li class="nav-item">
                    <a class="nav-link <?= ($currentPage ?? '') === 'dashboard' ? 'active' : '' ?>" href="<?= APP_URL ?>">
                        <i class="bi bi-speedometer2"></i>Dashboard
                    </a>
                </li>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?= in_array($currentPage ?? '', ['servers', 'vms', 'equipment', 'diagram']) ? 'active' : '' ?>" href="#" data-bs-toggle="dropdown">
                        <i class="bi bi-server"></i>Infrastruktura
                    </a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="<?= APP_URL ?>/modules/servers/"><i class="bi bi-server"></i>Serveri</a></li>
                        <li><a class="dropdown-item" href="<?= APP_URL ?>/modules/vms/"><i class="bi bi-pc-display"></i>Virtualke</a></li>
                        <li><a class="dropdown-item" href="<?= APP_URL ?>/modules/equipment/"><i class="bi bi-diagram-3"></i>Ostala oprema</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="<?= APP_URL ?>/network-diagram.php"><i class="bi bi-share"></i>Mrežni dijagram</a></li>
                    </ul>
                </li>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?= in_array($currentPage ?? '', ['pcs', 'laptops', 'tablets', 'phones']) ? 'active' : '' ?>" href="#" data-bs-toggle="dropdown">
                        <i class="bi bi-laptop"></i>Uređaji
                    </a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="<?= APP_URL ?>/modules/pcs/"><i class="bi bi-pc-display-horizontal"></i>PC računala</a></li>
                        <li><a class="dropdown-item" href="<?= APP_URL ?>/modules/laptops/"><i class="bi bi-laptop"></i>Laptopi</a></li>
                        <li><a class="dropdown-item" href="<?= APP_URL ?>/modules/tablets/"><i class="bi bi-tablet"></i>Tableti</a></li>
                        <li><a class="dropdown-item" href="<?= APP_URL ?>/modules/phones/"><i class="bi bi-phone"></i>Mobiteli</a></li>
                    </ul>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= ($currentPage ?? '') === 'users' ? 'active' : '' ?>" href="<?= APP_URL ?>/modules/users/">
                        <i class="bi bi-people"></i>Korisnici
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= ($currentPage ?? '') === 'printers' ? 'active' : '' ?>" href="<?= APP_URL ?>/modules/printers/">
                        <i class="bi bi-printer"></i>Printeri
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?= ($currentPage ?? '') === 'changelog' ? 'active' : '' ?>" href="<?= APP_URL ?>/changelog.php">
                        <i class="bi bi-clock-history"></i>Log
                    </a>
                </li>
            </ul>
            <ul class="navbar-nav">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown">
                        <i class="bi bi-person-circle"></i><?= clean($_SESSION['admin_name'] ?? 'Admin') ?>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="<?= APP_URL ?>/profile.php"><i class="bi bi-gear"></i>Profil</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="<?= APP_URL ?>/logout.php"><i class="bi bi-box-arrow-right"></i>Odjava</a></li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
</nav>
<?php endif; ?>

<main class="container-fluid">
<?php if ($flash = getFlash()): ?>
    <div class="alert alert-<?= $flash['type'] === 'error' ? 'danger' : $flash['type'] ?> alert-dismissible fade show">
        <i class="bi bi-<?= $flash['type'] === 'error' ? 'x-circle' : ($flash['type'] === 'success' ? 'check-circle' : 'info-circle') ?> me-2"></i>
        <?= clean($flash['message']) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif;
