<?php
require_once __DIR__ . '/config.php';
$pageTitle = 'Dashboard - ' . APP_NAME;
$currentPage = 'dashboard';

require_once __DIR__ . '/includes/header.php';
requireLogin();

$db = getDB();

// Safe count funkcija
function safeCount($db, $table, $hasStatus = false) {
    try {
        if ($hasStatus) {
            return $db->query("SELECT COUNT(*) FROM {$table} WHERE status = 'active'")->fetchColumn();
        }
        return $db->query("SELECT COUNT(*) FROM {$table}")->fetchColumn();
    } catch (PDOException $e) {
        return 0;
    }
}

// Statistike
$stats = [
    'servers' => safeCount($db, 'servers'),
    'vms' => safeCount($db, 'virtual_machines'),
    'users' => safeCount($db, 'users', true),
    'printers' => safeCount($db, 'printers'),
    'pcs' => safeCount($db, 'pcs', true),
    'laptops' => safeCount($db, 'laptops', true),
    'tablets' => safeCount($db, 'tablets', true),
    'phones' => safeCount($db, 'phones', true),
];

// Jamstva koja ističu u 30 dana
$expiringWarranties = [];
try {
    $tables = [
        'laptops' => 'Laptop',
        'pcs' => 'PC',
        'phones' => 'Mobitel'
    ];
    foreach ($tables as $table => $label) {
        $items = $db->query("SELECT id, name, warranty_until, '$label' as type FROM {$table} WHERE warranty_until BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 30 DAY)")->fetchAll();
        $expiringWarranties = array_merge($expiringWarranties, $items);
    }
    usort($expiringWarranties, fn($a, $b) => strtotime($a['warranty_until']) - strtotime($b['warranty_until']));
} catch (PDOException $e) {}
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4 class="mb-1"><i class="bi bi-speedometer2 me-2"></i>Dashboard</h4>
        <p class="text-muted mb-0">Pregled IT infrastrukture</p>
    </div>
    <div>
        <a href="<?= APP_URL ?>/network-diagram.php" class="btn btn-outline-primary">
            <i class="bi bi-diagram-3 me-1"></i>Mrežni dijagram
        </a>
    </div>
</div>

<!-- Infrastruktura -->
<h6 class="text-muted mb-3"><i class="bi bi-server me-2"></i>INFRASTRUKTURA</h6>
<div class="row g-4 mb-4">
    <div class="col-6 col-md-4 col-xl-3">
        <a href="<?= APP_URL ?>/modules/servers/" class="stat-card">
            <div class="stat-icon primary"><i class="bi bi-server"></i></div>
            <div class="stat-content">
                <h3><?= $stats['servers'] ?></h3>
                <p>Serveri</p>
            </div>
        </a>
    </div>
    <div class="col-6 col-md-4 col-xl-3">
        <a href="<?= APP_URL ?>/modules/vms/" class="stat-card">
            <div class="stat-icon info"><i class="bi bi-pc-display"></i></div>
            <div class="stat-content">
                <h3><?= $stats['vms'] ?></h3>
                <p>Virtualke</p>
            </div>
        </a>
    </div>
    <div class="col-6 col-md-4 col-xl-3">
        <a href="<?= APP_URL ?>/modules/users/" class="stat-card">
            <div class="stat-icon success"><i class="bi bi-people"></i></div>
            <div class="stat-content">
                <h3><?= $stats['users'] ?></h3>
                <p>Korisnici</p>
            </div>
        </a>
    </div>
    <div class="col-6 col-md-4 col-xl-3">
        <a href="<?= APP_URL ?>/modules/printers/" class="stat-card">
            <div class="stat-icon warning"><i class="bi bi-printer"></i></div>
            <div class="stat-content">
                <h3><?= $stats['printers'] ?></h3>
                <p>Printeri</p>
            </div>
        </a>
    </div>
</div>

<!-- Uređaji -->
<h6 class="text-muted mb-3"><i class="bi bi-laptop me-2"></i>UREĐAJI</h6>
<div class="row g-4 mb-4">
    <div class="col-6 col-md-3">
        <a href="<?= APP_URL ?>/modules/pcs/" class="stat-card">
            <div class="stat-icon primary"><i class="bi bi-pc-display-horizontal"></i></div>
            <div class="stat-content">
                <h3><?= $stats['pcs'] ?></h3>
                <p>PC računala</p>
            </div>
        </a>
    </div>
    <div class="col-6 col-md-3">
        <a href="<?= APP_URL ?>/modules/laptops/" class="stat-card">
            <div class="stat-icon info"><i class="bi bi-laptop"></i></div>
            <div class="stat-content">
                <h3><?= $stats['laptops'] ?></h3>
                <p>Laptopi</p>
            </div>
        </a>
    </div>
    <div class="col-6 col-md-3">
        <a href="<?= APP_URL ?>/modules/tablets/" class="stat-card">
            <div class="stat-icon success"><i class="bi bi-tablet"></i></div>
            <div class="stat-content">
                <h3><?= $stats['tablets'] ?></h3>
                <p>Tableti</p>
            </div>
        </a>
    </div>
    <div class="col-6 col-md-3">
        <a href="<?= APP_URL ?>/modules/phones/" class="stat-card">
            <div class="stat-icon warning"><i class="bi bi-phone"></i></div>
            <div class="stat-content">
                <h3><?= $stats['phones'] ?></h3>
                <p>Mobiteli</p>
            </div>
        </a>
    </div>
</div>

<!-- Jamstva koja ističu -->
<?php if (!empty($expiringWarranties)): ?>
<div class="row">
    <div class="col-lg-6">
        <div class="card">
            <div class="card-header">
                <h6><i class="bi bi-exclamation-triangle text-warning me-2"></i>Jamstva ističu (30 dana)</h6>
            </div>
            <div class="card-body">
                <ul class="device-list">
                    <?php foreach (array_slice($expiringWarranties, 0, 5) as $item): ?>
                    <li>
                        <div class="device-icon">
                            <i class="bi bi-<?= $item['type'] === 'Laptop' ? 'laptop' : ($item['type'] === 'PC' ? 'pc-display-horizontal' : 'phone') ?>"></i>
                        </div>
                        <div class="flex-grow-1">
                            <strong><?= clean($item['name']) ?></strong>
                            <br><small class="text-warning"><?= $item['type'] ?> · <?= formatDate($item['warranty_until']) ?></small>
                        </div>
                    </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
