<?php
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/includes/functions.php';

if (session_status() === PHP_SESSION_NONE) {
    session_name(SESSION_NAME);
    session_start();
}

if (isset($_SESSION['admin_id'])) {
    header('Location: ' . APP_URL);
    exit;
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if ($username && $password) {
        $db = getDB();
        $stmt = $db->prepare("SELECT * FROM admins WHERE username = ?");
        $stmt->execute([$username]);
        $admin = $stmt->fetch();
        
        if ($admin && password_verify($password, $admin['password'])) {
            $_SESSION['admin_id'] = $admin['id'];
            $_SESSION['admin_name'] = $admin['name'];
            $_SESSION['admin_role'] = $admin['role'];
            header('Location: ' . APP_URL);
            exit;
        } else {
            $error = 'Pogrešno korisničko ime ili lozinka';
        }
    } else {
        $error = 'Unesite korisničko ime i lozinku';
    }
}
?>
<!DOCTYPE html>
<html lang="hr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - <?= APP_NAME ?></title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=JetBrains+Mono:wght@400&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background: #0a0a0f;
            position: relative;
            overflow: hidden;
        }
        
        /* Animated Background */
        .bg-animation {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 0;
        }
        
        .bg-animation::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: 
                radial-gradient(ellipse at 20% 20%, rgba(0, 212, 255, 0.15) 0%, transparent 50%),
                radial-gradient(ellipse at 80% 80%, rgba(124, 58, 237, 0.15) 0%, transparent 50%),
                radial-gradient(ellipse at 40% 60%, rgba(16, 185, 129, 0.1) 0%, transparent 40%);
            animation: pulse 8s ease-in-out infinite;
        }
        
        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.7; }
        }
        
        /* Grid Pattern */
        .grid-pattern {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: 
                linear-gradient(rgba(0, 212, 255, 0.03) 1px, transparent 1px),
                linear-gradient(90deg, rgba(0, 212, 255, 0.03) 1px, transparent 1px);
            background-size: 50px 50px;
            z-index: 1;
        }
        
        /* Floating Particles */
        .particles {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 1;
            pointer-events: none;
        }
        
        .particle {
            position: absolute;
            width: 4px;
            height: 4px;
            background: rgba(0, 212, 255, 0.6);
            border-radius: 50%;
            animation: float 15s infinite;
            box-shadow: 0 0 10px rgba(0, 212, 255, 0.5);
        }
        
        .particle:nth-child(1) { left: 10%; animation-delay: 0s; animation-duration: 12s; }
        .particle:nth-child(2) { left: 20%; animation-delay: 2s; animation-duration: 18s; }
        .particle:nth-child(3) { left: 30%; animation-delay: 4s; animation-duration: 14s; }
        .particle:nth-child(4) { left: 40%; animation-delay: 1s; animation-duration: 16s; }
        .particle:nth-child(5) { left: 50%; animation-delay: 3s; animation-duration: 20s; }
        .particle:nth-child(6) { left: 60%; animation-delay: 5s; animation-duration: 13s; }
        .particle:nth-child(7) { left: 70%; animation-delay: 2s; animation-duration: 17s; }
        .particle:nth-child(8) { left: 80%; animation-delay: 4s; animation-duration: 15s; }
        .particle:nth-child(9) { left: 90%; animation-delay: 1s; animation-duration: 19s; }
        
        @keyframes float {
            0%, 100% {
                transform: translateY(100vh) scale(0);
                opacity: 0;
            }
            10% {
                opacity: 1;
            }
            90% {
                opacity: 1;
            }
            100% {
                transform: translateY(-100vh) scale(1);
                opacity: 0;
            }
        }
        
        /* Login Container */
        .login-container {
            position: relative;
            z-index: 10;
            width: 100%;
            max-width: 440px;
            padding: 1rem;
        }
        
        .login-card {
            background: rgba(18, 18, 26, 0.9);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(42, 42, 58, 0.8);
            border-radius: 24px;
            padding: 3rem;
            box-shadow: 
                0 25px 50px rgba(0, 0, 0, 0.5),
                0 0 100px rgba(0, 212, 255, 0.1),
                inset 0 1px 0 rgba(255, 255, 255, 0.05);
        }
        
        /* Logo */
        .logo {
            text-align: center;
            margin-bottom: 2.5rem;
        }
        
        .logo-icon {
            width: 80px;
            height: 80px;
            margin: 0 auto 1.25rem;
            background: linear-gradient(135deg, rgba(0, 212, 255, 0.2), rgba(124, 58, 237, 0.2));
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2.5rem;
            position: relative;
            animation: glow 3s ease-in-out infinite;
        }
        
        .logo-icon::before {
            content: '';
            position: absolute;
            inset: -2px;
            border-radius: 22px;
            background: linear-gradient(135deg, #00d4ff, #7c3aed, #10b981, #00d4ff);
            background-size: 300% 300%;
            animation: gradient 4s ease infinite;
            z-index: -1;
            opacity: 0.7;
        }
        
        .logo-icon i {
            background: linear-gradient(135deg, #00d4ff, #7c3aed);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            filter: drop-shadow(0 0 20px rgba(0, 212, 255, 0.5));
        }
        
        @keyframes gradient {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }
        
        @keyframes glow {
            0%, 100% { box-shadow: 0 0 30px rgba(0, 212, 255, 0.3); }
            50% { box-shadow: 0 0 50px rgba(0, 212, 255, 0.5); }
        }
        
        .logo h1 {
            font-size: 1.75rem;
            font-weight: 700;
            color: #fff;
            margin: 0 0 0.5rem;
            letter-spacing: -0.02em;
        }
        
        .logo p {
            color: #a0a0b0;
            font-size: 0.9rem;
            margin: 0;
        }
        
        /* Form */
        .form-group {
            margin-bottom: 1.5rem;
        }
        
        .form-label {
            display: block;
            color: #a0a0b0;
            font-size: 0.875rem;
            font-weight: 500;
            margin-bottom: 0.5rem;
        }
        
        .input-wrapper {
            position: relative;
        }
        
        .input-wrapper i {
            position: absolute;
            left: 1rem;
            top: 50%;
            transform: translateY(-50%);
            color: #606070;
            font-size: 1.1rem;
            transition: color 0.3s;
        }
        
        .form-control {
            width: 100%;
            background: rgba(26, 26, 37, 0.8);
            border: 1px solid #2a2a3a;
            color: #fff;
            padding: 1rem 1rem 1rem 3rem;
            border-radius: 12px;
            font-size: 1rem;
            font-family: inherit;
            transition: all 0.3s;
        }
        
        .form-control::placeholder {
            color: #606070;
        }
        
        .form-control:focus {
            outline: none;
            border-color: #00d4ff;
            box-shadow: 0 0 0 3px rgba(0, 212, 255, 0.1), 0 0 20px rgba(0, 212, 255, 0.2);
        }
        
        .form-control:focus + i,
        .input-wrapper:focus-within i {
            color: #00d4ff;
        }
        
        /* Button */
        .btn-login {
            width: 100%;
            background: linear-gradient(135deg, #00d4ff, #00a8cc);
            border: none;
            color: #000;
            padding: 1rem;
            border-radius: 12px;
            font-size: 1rem;
            font-weight: 600;
            font-family: inherit;
            cursor: pointer;
            transition: all 0.3s;
            position: relative;
            overflow: hidden;
        }
        
        .btn-login::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
            transition: left 0.5s;
        }
        
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 40px rgba(0, 212, 255, 0.4);
        }
        
        .btn-login:hover::before {
            left: 100%;
        }
        
        .btn-login:active {
            transform: translateY(0);
        }
        
        .btn-login i {
            margin-right: 0.5rem;
        }
        
        /* Error Message */
        .error-message {
            background: rgba(239, 68, 68, 0.1);
            border: 1px solid rgba(239, 68, 68, 0.3);
            color: #ef4444;
            padding: 1rem;
            border-radius: 12px;
            margin-bottom: 1.5rem;
            font-size: 0.9rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
            animation: shake 0.5s ease-in-out;
        }
        
        @keyframes shake {
            0%, 100% { transform: translateX(0); }
            20%, 60% { transform: translateX(-5px); }
            40%, 80% { transform: translateX(5px); }
        }
        
        /* Footer */
        .login-footer {
            text-align: center;
            margin-top: 2rem;
            color: #606070;
            font-size: 0.8rem;
        }
        
        .login-footer a {
            color: #00d4ff;
            text-decoration: none;
        }
        
        /* Version Badge */
        .version-badge {
            position: fixed;
            bottom: 1rem;
            right: 1rem;
            background: rgba(18, 18, 26, 0.8);
            border: 1px solid #2a2a3a;
            padding: 0.5rem 1rem;
            border-radius: 20px;
            font-size: 0.75rem;
            color: #606070;
            font-family: 'JetBrains Mono', monospace;
            z-index: 100;
        }
    </style>
</head>
<body>
    <div class="bg-animation"></div>
    <div class="grid-pattern"></div>
    <div class="particles">
        <div class="particle"></div>
        <div class="particle"></div>
        <div class="particle"></div>
        <div class="particle"></div>
        <div class="particle"></div>
        <div class="particle"></div>
        <div class="particle"></div>
        <div class="particle"></div>
        <div class="particle"></div>
    </div>
    
    <div class="login-container">
        <div class="login-card">
            <div class="logo">
                <div class="logo-icon">
                    <i class="bi bi-hdd-rack"></i>
                </div>
                <h1><?= APP_NAME ?></h1>
                <p>IT Asset Management System</p>
            </div>
            
            <?php if ($error): ?>
            <div class="error-message">
                <i class="bi bi-exclamation-circle"></i>
                <?= clean($error) ?>
            </div>
            <?php endif; ?>
            
            <form method="POST" autocomplete="off">
                <div class="form-group">
                    <label class="form-label">Korisničko ime</label>
                    <div class="input-wrapper">
                        <input type="text" name="username" class="form-control" placeholder="Unesite korisničko ime" required autofocus>
                        <i class="bi bi-person"></i>
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Lozinka</label>
                    <div class="input-wrapper">
                        <input type="password" name="password" class="form-control" placeholder="Unesite lozinku" required>
                        <i class="bi bi-lock"></i>
                    </div>
                </div>
                
                <button type="submit" class="btn-login">
                    <i class="bi bi-box-arrow-in-right"></i>
                    Prijava
                </button>
            </form>
            
            <div class="login-footer">
                <p>Powered by <a href="https://dromedar-it.hr" target="_blank">Dromedar IT</a></p>
            </div>
        </div>
    </div>
    
    <div class="version-badge">v<?= APP_VERSION ?></div>
</body>
</html>
