<?php
$pageTitle = 'Ostala oprema - IT Inventory';
$currentPage = 'equipment';

require_once __DIR__ . '/../../includes/header.php';
requireLogin();

$db = getDB();
$search = $_GET['search'] ?? '';
$type = $_GET['type'] ?? '';
$status = $_GET['status'] ?? '';

$where = [];
$params = [];

if ($search) {
    $where[] = "(name LIKE ? OR serial_number LIKE ? OR model LIKE ? OR ip_address LIKE ?)";
    $s = "%{$search}%";
    $params = array_merge($params, [$s, $s, $s, $s]);
}
if ($type) { $where[] = "type = ?"; $params[] = $type; }
if ($status) { $where[] = "status = ?"; $params[] = $status; }

$whereClause = $where ? 'WHERE ' . implode(' AND ', $where) : '';
$stmt = $db->prepare("SELECT * FROM equipment {$whereClause} ORDER BY type, name");
$stmt->execute($params);
$items = $stmt->fetchAll();

$typeLabels = [
    'switch' => ['Switch', 'bi-diagram-3', 'primary'],
    'router' => ['Router', 'bi-router', 'success'],
    'firewall' => ['Firewall', 'bi-shield-lock', 'danger'],
    'ups' => ['UPS', 'bi-battery-charging', 'warning'],
    'storage' => ['Storage', 'bi-device-hdd', 'info'],
    'nas' => ['NAS', 'bi-hdd-stack', 'info'],
    'san' => ['SAN', 'bi-hdd-network', 'info'],
    'ap' => ['Access Point', 'bi-wifi', 'success'],
    'other' => ['Ostalo', 'bi-box', 'secondary']
];
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4><i class="bi bi-diagram-3 me-2"></i>Ostala oprema</h4>
    <a href="add.php" class="btn btn-primary"><i class="bi bi-plus-lg me-1"></i>Nova oprema</a>
</div>

<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-4">
                <div class="search-box">
                    <i class="bi bi-search"></i>
                    <input type="text" name="search" class="form-control" placeholder="Pretraži..." value="<?= clean($search) ?>">
                </div>
            </div>
            <div class="col-md-3">
                <select name="type" class="form-select">
                    <option value="">Svi tipovi</option>
                    <?php foreach ($typeLabels as $k => $v): ?>
                    <option value="<?= $k ?>" <?= $type === $k ? 'selected' : '' ?>><?= $v[0] ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-3">
                <select name="status" class="form-select">
                    <option value="">Svi statusi</option>
                    <option value="active" <?= $status === 'active' ? 'selected' : '' ?>>Active</option>
                    <option value="maintenance" <?= $status === 'maintenance' ? 'selected' : '' ?>>Maintenance</option>
                    <option value="storage" <?= $status === 'storage' ? 'selected' : '' ?>>Storage</option>
                    <option value="retired" <?= $status === 'retired' ? 'selected' : '' ?>>Retired</option>
                </select>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-outline-secondary w-100">Filtriraj</button>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>Tip</th>
                    <th>Naziv</th>
                    <th>Model</th>
                    <th>IP adresa</th>
                    <th>Lokacija</th>
                    <th>Status</th>
                    <th class="text-end">Akcije</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($items)): ?>
                <tr><td colspan="7" class="text-center text-muted py-4"><i class="bi bi-inbox display-6 d-block mb-2"></i>Nema opreme</td></tr>
                <?php else: ?>
                <?php foreach ($items as $item): ?>
                <?php $tl = $typeLabels[$item['type']] ?? $typeLabels['other']; ?>
                <tr>
                    <td><span class="badge bg-<?= $tl[2] ?>"><i class="bi <?= $tl[1] ?> me-1"></i><?= $tl[0] ?></span></td>
                    <td>
                        <a href="view.php?id=<?= $item['id'] ?>" class="fw-bold text-decoration-none"><?= clean($item['name']) ?></a>
                        <?php if ($item['asset_tag']): ?><br><small class="text-muted"><?= clean($item['asset_tag']) ?></small><?php endif; ?>
                    </td>
                    <td><?= clean($item['manufacturer']) ?> <?= clean($item['model']) ?></td>
                    <td><?= $item['ip_address'] ? '<code>' . clean($item['ip_address']) . '</code>' : '-' ?></td>
                    <td><?= clean($item['location']) ?: '-' ?></td>
                    <td><?= statusBadge($item['status']) ?></td>
                    <td class="text-end">
                        <a href="view.php?id=<?= $item['id'] ?>" class="btn btn-sm btn-outline-primary"><i class="bi bi-eye"></i></a>
                        <a href="edit.php?id=<?= $item['id'] ?>" class="btn btn-sm btn-outline-secondary"><i class="bi bi-pencil"></i></a>
                        <a href="delete.php?id=<?= $item['id'] ?>" class="btn btn-sm btn-outline-danger" data-confirm="Obrisati opremu?"><i class="bi bi-trash"></i></a>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
