<?php
require_once __DIR__ . '/../../includes/header.php';
requireLogin();
$db = getDB();
$stmt = $db->prepare("SELECT * FROM equipment WHERE id = ?");
$stmt->execute([$_GET['id'] ?? 0]);
$item = $stmt->fetch();
if (!$item) { setFlash('error', 'Oprema nije pronađena.'); header('Location: index.php'); exit; }

$typeLabels = [
    'switch' => ['Switch', 'bi-diagram-3', 'primary'],
    'router' => ['Router', 'bi-router', 'success'],
    'firewall' => ['Firewall', 'bi-shield-lock', 'danger'],
    'ups' => ['UPS', 'bi-battery-charging', 'warning'],
    'storage' => ['Storage', 'bi-device-hdd', 'info'],
    'nas' => ['NAS', 'bi-hdd-stack', 'info'],
    'san' => ['SAN', 'bi-hdd-network', 'info'],
    'ap' => ['Access Point', 'bi-wifi', 'success'],
    'other' => ['Ostalo', 'bi-box', 'secondary']
];
$tl = $typeLabels[$item['type']] ?? $typeLabels['other'];
$pageTitle = $item['name'] . ' - IT Inventory';
$currentPage = 'equipment';
?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4><i class="bi <?= $tl[1] ?> me-2"></i><?= clean($item['name']) ?> <?= statusBadge($item['status']) ?></h4>
        <p class="text-muted mb-0"><span class="badge bg-<?= $tl[2] ?>"><?= $tl[0] ?></span> · <?= clean($item['manufacturer']) ?> <?= clean($item['model']) ?></p>
    </div>
    <div>
        <a href="edit.php?id=<?= $item['id'] ?>" class="btn btn-outline-primary"><i class="bi bi-pencil me-1"></i>Uredi</a>
        <a href="index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-1"></i>Natrag</a>
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-header bg-white"><h6 class="mb-0">Informacije</h6></div>
            <div class="card-body">
                <table class="table table-sm">
                    <tr><th class="text-muted" style="width:35%">Asset tag</th><td><?= clean($item['asset_tag']) ?: '-' ?></td></tr>
                    <tr><th class="text-muted">Serijski broj</th><td><code><?= clean($item['serial_number']) ?: '-' ?></code></td></tr>
                    <tr><th class="text-muted">Lokacija</th><td><?= clean($item['location']) ?: '-' ?></td></tr>
                    <tr><th class="text-muted">Rack pozicija</th><td><?= clean($item['rack_position']) ?: '-' ?></td></tr>
                    <tr><th class="text-muted">Broj portova</th><td><?= $item['ports_count'] ?: '-' ?></td></tr>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-header bg-white"><h6 class="mb-0">Mreža & Jamstvo</h6></div>
            <div class="card-body">
                <table class="table table-sm">
                    <tr><th class="text-muted" style="width:35%">IP adresa</th><td><?= $item['ip_address'] ? '<code>' . clean($item['ip_address']) . '</code>' : '-' ?></td></tr>
                    <tr><th class="text-muted">MAC adresa</th><td><?= $item['mac_address'] ? '<code>' . clean($item['mac_address']) . '</code>' : '-' ?></td></tr>
                    <tr><th class="text-muted">Datum kupnje</th><td><?= formatDate($item['purchase_date']) ?></td></tr>
                    <tr><th class="text-muted">Jamstvo do</th><td><?= formatDate($item['warranty_until']) ?></td></tr>
                </table>
            </div>
        </div>
    </div>
</div>
<?php if ($item['notes']): ?><div class="card"><div class="card-header bg-white"><h6 class="mb-0">Napomene</h6></div><div class="card-body"><?= nl2br(clean($item['notes'])) ?></div></div><?php endif; ?>
<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
