<?php
$pageTitle = 'Laptopi - IT Inventory';
$currentPage = 'laptops';

require_once __DIR__ . '/../../includes/header.php';
requireLogin();

$db = getDB();
$search = $_GET['search'] ?? '';
$status = $_GET['status'] ?? '';

$where = [];
$params = [];

if ($search) {
    $where[] = "(name LIKE ? OR serial_number LIKE ? OR assigned_to LIKE ? OR model LIKE ?)";
    $s = "%{$search}%";
    $params = array_merge($params, [$s, $s, $s, $s]);
}
if ($status) { $where[] = "status = ?"; $params[] = $status; }

$whereClause = $where ? 'WHERE ' . implode(' AND ', $where) : '';
$stmt = $db->prepare("SELECT * FROM laptops {$whereClause} ORDER BY name");
$stmt->execute($params);
$laptops = $stmt->fetchAll();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4><i class="bi bi-laptop me-2"></i>Laptopi</h4>
    <a href="add.php" class="btn btn-primary"><i class="bi bi-plus-lg me-1"></i>Novi laptop</a>
</div>

<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-6">
                <div class="search-box">
                    <i class="bi bi-search"></i>
                    <input type="text" name="search" class="form-control" placeholder="Pretraži..." value="<?= clean($search) ?>">
                </div>
            </div>
            <div class="col-md-4">
                <select name="status" class="form-select">
                    <option value="">Svi statusi</option>
                    <option value="active" <?= $status === 'active' ? 'selected' : '' ?>>Active</option>
                    <option value="maintenance" <?= $status === 'maintenance' ? 'selected' : '' ?>>Maintenance</option>
                    <option value="storage" <?= $status === 'storage' ? 'selected' : '' ?>>Storage</option>
                    <option value="retired" <?= $status === 'retired' ? 'selected' : '' ?>>Retired</option>
                </select>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-outline-secondary w-100">Filtriraj</button>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>Naziv</th>
                    <th>Model</th>
                    <th>Serijski br.</th>
                    <th>Spec</th>
                    <th>Dodijeljen</th>
                    <th>Status</th>
                    <th class="text-end">Akcije</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($laptops)): ?>
                <tr><td colspan="7" class="text-center text-muted py-4"><i class="bi bi-inbox display-6 d-block mb-2"></i>Nema laptopa</td></tr>
                <?php else: ?>
                <?php foreach ($laptops as $l): ?>
                <tr>
                    <td>
                        <a href="view.php?id=<?= $l['id'] ?>" class="fw-bold text-decoration-none"><?= clean($l['name']) ?></a>
                        <?php if ($l['asset_tag']): ?><br><small class="text-muted"><?= clean($l['asset_tag']) ?></small><?php endif; ?>
                    </td>
                    <td><?= clean($l['manufacturer']) ?> <?= clean($l['model']) ?></td>
                    <td><code><?= clean($l['serial_number']) ?: '-' ?></code></td>
                    <td><small><?= clean($l['cpu']) ?><br><?= $l['ram_gb'] ?>GB / <?= $l['storage_gb'] ?>GB <?= $l['storage_type'] ?></small></td>
                    <td><?= clean($l['assigned_to']) ?: '<span class="text-muted">-</span>' ?></td>
                    <td><?= statusBadge($l['status']) ?></td>
                    <td class="text-end">
                        <a href="view.php?id=<?= $l['id'] ?>" class="btn btn-sm btn-outline-primary"><i class="bi bi-eye"></i></a>
                        <a href="edit.php?id=<?= $l['id'] ?>" class="btn btn-sm btn-outline-secondary"><i class="bi bi-pencil"></i></a>
                        <a href="delete.php?id=<?= $l['id'] ?>" class="btn btn-sm btn-outline-danger" data-confirm="Obrisati laptop?"><i class="bi bi-trash"></i></a>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
