<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/functions.php';
require_once __DIR__ . '/../../includes/auth.php';

if (session_status() === PHP_SESSION_NONE) { session_name(SESSION_NAME); session_start(); }
if (!isLoggedIn()) { header('Location: ' . APP_URL . '/login.php'); exit; }
if (!isAdmin()) { setFlash('error', 'Nemate ovlasti.'); header('Location: index.php'); exit; }

$db = getDB();
$stmt = $db->prepare("SELECT * FROM licenses WHERE id = ?");
$stmt->execute([$_GET['id'] ?? 0]);
$item = $stmt->fetch();

if (!$item) { setFlash('error', 'Licencija nije pronađena.'); header('Location: index.php'); exit; }

$stmt = $db->prepare("DELETE FROM licenses WHERE id = ?");
$stmt->execute([$item['id']]);
logChange('delete', 'license', $item['id'], $item['name'], $item, null);

setFlash('success', 'Licencija je obrisana.');
header('Location: index.php');
exit;
