<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/functions.php';
require_once __DIR__ . '/../../includes/auth.php';

if (session_status() === PHP_SESSION_NONE) { session_name(SESSION_NAME); session_start(); }
if (!isLoggedIn()) { header('Location: ' . APP_URL . '/login.php'); exit; }

$isEdit = isset($_GET['id']);
$db = getDB();
$license = null;
$errors = [];

if ($isEdit) {
    $stmt = $db->prepare("SELECT * FROM licenses WHERE id = ?");
    $stmt->execute([$_GET['id']]);
    $license = $stmt->fetch();
    if (!$license) { setFlash('error', 'Licencija nije pronađena.'); header('Location: index.php'); exit; }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verifyCSRF($_POST['csrf_token'] ?? '')) { $errors[] = 'Nevažeći CSRF token.'; }
    
    $data = [
        'software_name' => trim($_POST['software_name'] ?? ''),
        'license_type' => $_POST['license_type'] ?? 'perpetual',
        'license_key' => trim($_POST['license_key'] ?? ''),
        'quantity' => (int)($_POST['quantity'] ?? 1),
        'used_quantity' => (int)($_POST['used_quantity'] ?? 0),
        'vendor' => trim($_POST['vendor'] ?? ''),
        'purchase_date' => $_POST['purchase_date'] ?: null,
        'expiry_date' => $_POST['expiry_date'] ?: null,
        'cost' => (float)($_POST['cost'] ?? 0),
        'assigned_to' => trim($_POST['assigned_to'] ?? ''),
        'notes' => trim($_POST['notes'] ?? '')
    ];
    
    if (empty($data['software_name'])) $errors[] = 'Naziv softvera je obavezan.';
    
    if (empty($errors)) {
        try {
            if ($isEdit) {
                $stmt = $db->prepare("UPDATE licenses SET software_name=?, license_type=?, license_key=?, quantity=?, used_quantity=?, vendor=?, purchase_date=?, expiry_date=?, cost=?, assigned_to=?, notes=? WHERE id=?");
                $stmt->execute([$data['software_name'], $data['license_type'], $data['license_key'], $data['quantity'], $data['used_quantity'], $data['vendor'], $data['purchase_date'], $data['expiry_date'], $data['cost'], $data['assigned_to'], $data['notes'], $_GET['id']]);
                logChange('update', 'license', $_GET['id'], $data['software_name'], $license, $data);
                setFlash('success', 'Licencija je ažurirana.');
            } else {
                $stmt = $db->prepare("INSERT INTO licenses (software_name, license_type, license_key, quantity, used_quantity, vendor, purchase_date, expiry_date, cost, assigned_to, notes) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                $stmt->execute([$data['software_name'], $data['license_type'], $data['license_key'], $data['quantity'], $data['used_quantity'], $data['vendor'], $data['purchase_date'], $data['expiry_date'], $data['cost'], $data['assigned_to'], $data['notes']]);
                logChange('create', 'license', $db->lastInsertId(), $data['software_name'], null, $data);
                setFlash('success', 'Licencija je dodana.');
            }
            header('Location: index.php'); exit;
        } catch (PDOException $e) { $errors[] = 'Greška: ' . $e->getMessage(); }
    }
    $license = $data;
}

$pageTitle = ($isEdit ? 'Uredi' : 'Nova') . ' licencija - IT Inventory';
$currentPage = 'licenses';
require_once __DIR__ . '/../../includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4><i class="bi bi-key me-2"></i><?= $isEdit ? 'Uredi licenciju' : 'Nova licencija' ?></h4>
    <a href="index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-1"></i>Natrag</a>
</div>

<?php if ($errors): ?><div class="alert alert-danger"><ul class="mb-0"><?php foreach ($errors as $e): ?><li><?= clean($e) ?></li><?php endforeach; ?></ul></div><?php endif; ?>

<div class="card">
    <div class="card-body">
        <form method="POST">
            <input type="hidden" name="csrf_token" value="<?= generateCSRF() ?>">
            <div class="row">
                <div class="col-md-6">
                    <h6 class="text-muted mb-3">Osnovni podaci</h6>
                    <div class="mb-3">
                        <label class="form-label required">Naziv softvera</label>
                        <input type="text" name="software_name" class="form-control" value="<?= clean($license['software_name'] ?? '') ?>" required placeholder="Microsoft Office 365">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Tip licencije</label>
                        <select name="license_type" class="form-select">
                            <option value="perpetual" <?= ($license['license_type'] ?? '') === 'perpetual' ? 'selected' : '' ?>>Perpetual (trajna)</option>
                            <option value="subscription" <?= ($license['license_type'] ?? '') === 'subscription' ? 'selected' : '' ?>>Subscription (pretplata)</option>
                            <option value="oem" <?= ($license['license_type'] ?? '') === 'oem' ? 'selected' : '' ?>>OEM</option>
                            <option value="volume" <?= ($license['license_type'] ?? '') === 'volume' ? 'selected' : '' ?>>Volume</option>
                            <option value="free" <?= ($license['license_type'] ?? '') === 'free' ? 'selected' : '' ?>>Free/Open Source</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Licencni ključ</label>
                        <textarea name="license_key" class="form-control" rows="2" placeholder="XXXXX-XXXXX-XXXXX-XXXXX-XXXXX"><?= clean($license['license_key'] ?? '') ?></textarea>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Vendor/Dobavljač</label>
                        <input type="text" name="vendor" class="form-control" value="<?= clean($license['vendor'] ?? '') ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Dodijeljeno</label>
                        <input type="text" name="assigned_to" class="form-control" value="<?= clean($license['assigned_to'] ?? '') ?>" placeholder="Odjel, računalo, korisnik...">
                    </div>
                </div>
                <div class="col-md-6">
                    <h6 class="text-muted mb-3">Količine i datumi</h6>
                    <div class="row">
                        <div class="col-6 mb-3">
                            <label class="form-label">Ukupna količina</label>
                            <input type="number" name="quantity" class="form-control" value="<?= (int)($license['quantity'] ?? 1) ?>" min="1">
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label">Iskorišteno</label>
                            <input type="number" name="used_quantity" class="form-control" value="<?= (int)($license['used_quantity'] ?? 0) ?>" min="0">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6 mb-3">
                            <label class="form-label">Datum kupnje</label>
                            <input type="date" name="purchase_date" class="form-control" value="<?= $license['purchase_date'] ?? '' ?>">
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label">Datum isteka</label>
                            <input type="date" name="expiry_date" class="form-control" value="<?= $license['expiry_date'] ?? '' ?>">
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Cijena (EUR)</label>
                        <input type="number" name="cost" class="form-control" value="<?= (float)($license['cost'] ?? 0) ?>" step="0.01" min="0">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Napomene</label>
                        <textarea name="notes" class="form-control" rows="4"><?= clean($license['notes'] ?? '') ?></textarea>
                    </div>
                </div>
            </div>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary"><i class="bi bi-check-lg me-1"></i><?= $isEdit ? 'Spremi' : 'Dodaj' ?></button>
                <a href="index.php" class="btn btn-outline-secondary">Odustani</a>
            </div>
        </form>
    </div>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
