<?php
require_once __DIR__ . '/../../includes/header.php';
requireLogin();
$db = getDB();
$stmt = $db->prepare("SELECT p.*, u.full_name as user_name FROM pcs p LEFT JOIN users u ON p.user_id = u.id WHERE p.id = ?");
$stmt->execute([$_GET['id'] ?? 0]);
$item = $stmt->fetch();
if (!$item) { setFlash('error', 'PC nije pronađen.'); header('Location: index.php'); exit; }
$pageTitle = $item['name'] . ' - IT Inventory';
$currentPage = 'pcs';
?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4><i class="bi bi-pc-display-horizontal me-2"></i><?= clean($item['name']) ?> <?= statusBadge($item['status']) ?></h4>
        <p class="text-muted mb-0"><?= clean($item['manufacturer']) ?> <?= clean($item['model']) ?> · S/N: <code><?= clean($item['serial_number']) ?></code></p>
    </div>
    <div>
        <a href="edit.php?id=<?= $item['id'] ?>" class="btn btn-outline-primary"><i class="bi bi-pencil me-1"></i>Uredi</a>
        <a href="index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-1"></i>Natrag</a>
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-header bg-white"><h6 class="mb-0">Specifikacije</h6></div>
            <div class="card-body">
                <table class="table table-sm">
                    <tr><th class="text-muted" style="width:35%">CPU</th><td><?= clean($item['cpu']) ?: '-' ?></td></tr>
                    <tr><th class="text-muted">RAM</th><td><?= $item['ram_gb'] ?> GB</td></tr>
                    <tr><th class="text-muted">Storage</th><td><?= $item['storage_gb'] ?> GB <?= $item['storage_type'] ?></td></tr>
                    <tr><th class="text-muted">OS</th><td><?= clean($item['os']) ?: '-' ?></td></tr>
                    <tr><th class="text-muted">IP adresa</th><td><?= $item['ip_address'] ? '<code>' . clean($item['ip_address']) . '</code>' : '-' ?></td></tr>
                    <tr><th class="text-muted">MAC adresa</th><td><?= $item['mac_address'] ? '<code>' . clean($item['mac_address']) . '</code>' : '-' ?></td></tr>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-header bg-white"><h6 class="mb-0">Dodjela & Jamstvo</h6></div>
            <div class="card-body">
                <table class="table table-sm">
                    <tr><th class="text-muted" style="width:35%">Asset tag</th><td><?= clean($item['asset_tag']) ?: '-' ?></td></tr>
                    <tr><th class="text-muted">Korisnik</th><td><?= $item['user_id'] ? '<a href="'.APP_URL.'/modules/users/view.php?id='.$item['user_id'].'">'.clean($item['user_name']).'</a>' : '-' ?></td></tr>
                    <tr><th class="text-muted">Odjel</th><td><?= clean($item['department']) ?: '-' ?></td></tr>
                    <tr><th class="text-muted">Lokacija</th><td><?= clean($item['location']) ?: '-' ?></td></tr>
                    <tr><th class="text-muted">Datum kupnje</th><td><?= formatDate($item['purchase_date']) ?></td></tr>
                    <tr><th class="text-muted">Jamstvo do</th><td><?= formatDate($item['warranty_until']) ?></td></tr>
                </table>
            </div>
        </div>
    </div>
</div>
<?php if ($item['notes']): ?><div class="card"><div class="card-header bg-white"><h6 class="mb-0">Napomene</h6></div><div class="card-body"><?= nl2br(clean($item['notes'])) ?></div></div><?php endif; ?>
<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
