<?php
$pageTitle = 'Printeri - IT Inventory';
$currentPage = 'printers';

require_once __DIR__ . '/../../includes/header.php';
requireLogin();

$db = getDB();
$search = $_GET['search'] ?? '';
$status = $_GET['status'] ?? '';

$where = [];
$params = [];

if ($search) {
    $where[] = "(name LIKE ? OR ip_address LIKE ? OR location LIKE ? OR model LIKE ?)";
    $s = "%{$search}%";
    $params = array_merge($params, [$s, $s, $s, $s]);
}
if ($status) { $where[] = "status = ?"; $params[] = $status; }

$whereClause = $where ? 'WHERE ' . implode(' AND ', $where) : '';
$stmt = $db->prepare("SELECT * FROM printers {$whereClause} ORDER BY name");
$stmt->execute($params);
$printers = $stmt->fetchAll();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4><i class="bi bi-printer me-2"></i>Printeri</h4>
    <a href="add.php" class="btn btn-primary"><i class="bi bi-plus-lg me-1"></i>Novi printer</a>
</div>

<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-6">
                <div class="search-box">
                    <i class="bi bi-search"></i>
                    <input type="text" name="search" class="form-control" placeholder="Pretraži..." value="<?= clean($search) ?>">
                </div>
            </div>
            <div class="col-md-4">
                <select name="status" class="form-select">
                    <option value="">Svi statusi</option>
                    <option value="active" <?= $status === 'active' ? 'selected' : '' ?>>Active</option>
                    <option value="maintenance" <?= $status === 'maintenance' ? 'selected' : '' ?>>Maintenance</option>
                    <option value="offline" <?= $status === 'offline' ? 'selected' : '' ?>>Offline</option>
                    <option value="retired" <?= $status === 'retired' ? 'selected' : '' ?>>Retired</option>
                </select>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-outline-secondary w-100">Filtriraj</button>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>Naziv</th>
                    <th>IP adresa</th>
                    <th>Model</th>
                    <th>Lokacija</th>
                    <th class="text-center">Tip</th>
                    <th>Status</th>
                    <th class="text-end">Akcije</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($printers)): ?>
                <tr><td colspan="7" class="text-center text-muted py-4"><i class="bi bi-inbox display-6 d-block mb-2"></i>Nema printera</td></tr>
                <?php else: ?>
                <?php foreach ($printers as $p): ?>
                <tr>
                    <td>
                        <a href="view.php?id=<?= $p['id'] ?>" class="fw-bold text-decoration-none"><?= clean($p['name']) ?></a>
                        <?php if ($p['network_name']): ?><br><small class="text-muted"><?= clean($p['network_name']) ?></small><?php endif; ?>
                    </td>
                    <td>
                        <code><?= clean($p['ip_address']) ?></code>
                        <button class="btn btn-sm btn-link p-0 ms-1" data-copy="<?= clean($p['ip_address']) ?>"><i class="bi bi-clipboard"></i></button>
                    </td>
                    <td><?= clean($p['manufacturer']) ?> <?= clean($p['model']) ?></td>
                    <td><?= clean($p['location']) ?: '-' ?></td>
                    <td class="text-center">
                        <span class="badge bg-<?= $p['color'] ? 'info' : 'secondary' ?>"><?= ucfirst($p['type']) ?></span>
                        <?php if ($p['color']): ?><span class="badge bg-success">Color</span><?php endif; ?>
                    </td>
                    <td><?= statusBadge($p['status']) ?></td>
                    <td class="text-end">
                        <a href="view.php?id=<?= $p['id'] ?>" class="btn btn-sm btn-outline-primary"><i class="bi bi-eye"></i></a>
                        <a href="edit.php?id=<?= $p['id'] ?>" class="btn btn-sm btn-outline-secondary"><i class="bi bi-pencil"></i></a>
                        <a href="delete.php?id=<?= $p['id'] ?>" class="btn btn-sm btn-outline-danger" data-confirm="Obrisati printer?"><i class="bi bi-trash"></i></a>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
