<?php
require_once __DIR__ . '/../../includes/header.php';
requireLogin();
$db = getDB();
$stmt = $db->prepare("SELECT * FROM printers WHERE id = ?");
$stmt->execute([$_GET['id'] ?? 0]);
$printer = $stmt->fetch();
if (!$printer) { setFlash('error', 'Printer nije pronađen.'); header('Location: index.php'); exit; }
$pageTitle = $printer['name'] . ' - IT Inventory';
$currentPage = 'printers';
?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4><i class="bi bi-printer me-2"></i><?= clean($printer['name']) ?> <?= statusBadge($printer['status']) ?></h4>
        <p class="text-muted mb-0"><code><?= clean($printer['ip_address']) ?></code> · <?= clean($printer['manufacturer']) ?> <?= clean($printer['model']) ?></p>
    </div>
    <div>
        <a href="edit.php?id=<?= $printer['id'] ?>" class="btn btn-outline-primary"><i class="bi bi-pencil me-1"></i>Uredi</a>
        <a href="index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-1"></i>Natrag</a>
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-header bg-white"><h6 class="mb-0">Informacije</h6></div>
            <div class="card-body">
                <table class="table table-sm">
                    <tr><th class="text-muted" style="width:35%">MAC adresa</th><td><code><?= clean($printer['mac_address']) ?: '-' ?></code></td></tr>
                    <tr><th class="text-muted">Serijski broj</th><td><?= clean($printer['serial_number']) ?: '-' ?></td></tr>
                    <tr><th class="text-muted">Lokacija</th><td><?= clean($printer['location']) ?: '-' ?></td></tr>
                    <tr><th class="text-muted">Mrežno ime</th><td><code><?= clean($printer['network_name']) ?: '-' ?></code></td></tr>
                    <tr><th class="text-muted">Driver</th><td><?= clean($printer['driver_info']) ?: '-' ?></td></tr>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-header bg-white"><h6 class="mb-0">Specifikacije</h6></div>
            <div class="card-body">
                <table class="table table-sm">
                    <tr><th class="text-muted" style="width:35%">Tip</th><td><span class="badge bg-secondary"><?= ucfirst($printer['type']) ?></span></td></tr>
                    <tr><th class="text-muted">Color</th><td><?= $printer['color'] ? '<span class="badge bg-success">Da</span>' : '<span class="badge bg-secondary">Ne</span>' ?></td></tr>
                    <tr><th class="text-muted">Duplex</th><td><?= $printer['duplex'] ? '<span class="badge bg-success">Da</span>' : '<span class="badge bg-secondary">Ne</span>' ?></td></tr>
                    <tr><th class="text-muted">Kreiran</th><td><?= formatDateTime($printer['created_at']) ?></td></tr>
                    <tr><th class="text-muted">Ažuriran</th><td><?= formatDateTime($printer['updated_at']) ?></td></tr>
                </table>
            </div>
        </div>
    </div>
</div>
<?php if ($printer['notes']): ?><div class="card"><div class="card-header bg-white"><h6 class="mb-0">Napomene</h6></div><div class="card-body"><?= nl2br(clean($printer['notes'])) ?></div></div><?php endif; ?>
<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
