<?php
/**
 * IT Inventory - View Server
 */
require_once __DIR__ . '/../../includes/header.php';
requireLogin();

$db = getDB();

$stmt = $db->prepare("SELECT * FROM servers WHERE id = ?");
$stmt->execute([$_GET['id'] ?? 0]);
$server = $stmt->fetch();

if (!$server) {
    setFlash('error', 'Server nije pronađen.');
    header('Location: index.php');
    exit;
}

$pageTitle = $server['name'] . ' - IT Inventory';
$currentPage = 'servers';

// Dohvati VM-ove na ovom serveru
$stmt = $db->prepare("SELECT * FROM virtual_machines WHERE server_id = ? ORDER BY name");
$stmt->execute([$server['id']]);
$vms = $stmt->fetchAll();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4>
            <i class="bi bi-server me-2"></i><?= clean($server['name']) ?>
            <?= statusBadge($server['status']) ?>
        </h4>
        <p class="text-muted mb-0">
            <code><?= clean($server['ip_address']) ?></code>
            <?php if ($server['hostname']): ?>
            · <?= clean($server['hostname']) ?>
            <?php endif; ?>
        </p>
    </div>
    <div>
        <a href="edit.php?id=<?= $server['id'] ?>" class="btn btn-outline-primary">
            <i class="bi bi-pencil me-1"></i>Uredi
        </a>
        <a href="index.php" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-1"></i>Natrag
        </a>
    </div>
</div>

<div class="row">
    <div class="col-lg-4">
        <div class="card mb-4">
            <div class="card-header bg-white">
                <h6 class="mb-0">Informacije o serveru</h6>
            </div>
            <div class="card-body">
                <table class="table table-sm">
                    <tr>
                        <th class="text-muted" style="width:40%">Lokacija</th>
                        <td><?= clean($server['location']) ?: '-' ?></td>
                    </tr>
                    <tr>
                        <th class="text-muted">CPU</th>
                        <td><?= clean($server['cpu']) ?: '-' ?></td>
                    </tr>
                    <tr>
                        <th class="text-muted">RAM</th>
                        <td><?= $server['ram_gb'] ? formatSize($server['ram_gb']) : '-' ?></td>
                    </tr>
                    <tr>
                        <th class="text-muted">Storage</th>
                        <td><?= nl2br(clean($server['storage_info'])) ?: '-' ?></td>
                    </tr>
                    <tr>
                        <th class="text-muted">OS</th>
                        <td><?= clean($server['os_version']) ?: '-' ?></td>
                    </tr>
                    <tr>
                        <th class="text-muted">Proxmox</th>
                        <td><?= clean($server['proxmox_version']) ?: '-' ?></td>
                    </tr>
                    <tr>
                        <th class="text-muted">Dodan</th>
                        <td><?= formatDateTime($server['created_at']) ?></td>
                    </tr>
                    <tr>
                        <th class="text-muted">Ažuriran</th>
                        <td><?= formatDateTime($server['updated_at']) ?></td>
                    </tr>
                </table>
                
                <?php if ($server['notes']): ?>
                <hr>
                <h6 class="text-muted">Napomene</h6>
                <p class="mb-0"><?= nl2br(clean($server['notes'])) ?></p>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header bg-white d-flex justify-content-between align-items-center">
                <h6 class="mb-0">
                    <i class="bi bi-pc-display me-2"></i>Virtualne mašine (<?= count($vms) ?>)
                </h6>
                <a href="<?= APP_URL ?>/modules/vms/add.php?server_id=<?= $server['id'] ?>" class="btn btn-sm btn-primary">
                    <i class="bi bi-plus-lg me-1"></i>Nova VM
                </a>
            </div>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th>VMID</th>
                            <th>Naziv</th>
                            <th>IP</th>
                            <th>OS</th>
                            <th>CPU/RAM</th>
                            <th>Status</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($vms)): ?>
                        <tr>
                            <td colspan="7" class="text-center text-muted py-4">Nema virtualnih mašina</td>
                        </tr>
                        <?php else: ?>
                        <?php foreach ($vms as $vm): ?>
                        <tr>
                            <td><code><?= $vm['vmid'] ?: '-' ?></code></td>
                            <td>
                                <a href="<?= APP_URL ?>/modules/vms/view.php?id=<?= $vm['id'] ?>" class="fw-bold text-decoration-none">
                                    <?= clean($vm['name']) ?>
                                </a>
                            </td>
                            <td><code><?= clean($vm['ip_address']) ?: '-' ?></code></td>
                            <td><?= clean($vm['os']) ?: '-' ?></td>
                            <td><?= $vm['cpu_cores'] ?>C / <?= formatSize($vm['ram_gb']) ?></td>
                            <td><?= statusBadge($vm['status']) ?></td>
                            <td class="text-end">
                                <a href="<?= APP_URL ?>/modules/vms/edit.php?id=<?= $vm['id'] ?>" class="btn btn-sm btn-outline-secondary">
                                    <i class="bi bi-pencil"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
