<?php
require_once __DIR__ . '/../../includes/header.php';
requireLogin();
$db = getDB();
$stmt = $db->prepare("SELECT * FROM tablets WHERE id = ?");
$stmt->execute([$_GET['id'] ?? 0]);
$item = $stmt->fetch();
if (!$item) { setFlash('error', 'Tablet nije pronađen.'); header('Location: index.php'); exit; }
$pageTitle = $item['name'] . ' - IT Inventory';
$currentPage = 'tablets';
?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4><i class="bi bi-tablet me-2"></i><?= clean($item['name']) ?> <?= statusBadge($item['status']) ?></h4>
        <p class="text-muted mb-0"><?= clean($item['manufacturer']) ?> <?= clean($item['model']) ?></p>
    </div>
    <div>
        <a href="edit.php?id=<?= $item['id'] ?>" class="btn btn-outline-primary"><i class="bi bi-pencil me-1"></i>Uredi</a>
        <a href="index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-1"></i>Natrag</a>
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-header bg-white"><h6 class="mb-0">Specifikacije</h6></div>
            <div class="card-body">
                <table class="table table-sm">
                    <tr><th class="text-muted" style="width:35%">Serijski br.</th><td><code><?= clean($item['serial_number']) ?: '-' ?></code></td></tr>
                    <tr><th class="text-muted">IMEI</th><td><code><?= clean($item['imei']) ?: '-' ?></code></td></tr>
                    <tr><th class="text-muted">Storage</th><td><?= $item['storage_gb'] ?> GB</td></tr>
                    <tr><th class="text-muted">Ekran</th><td><?= clean($item['screen_size']) ?: '-' ?></td></tr>
                    <tr><th class="text-muted">OS</th><td><?= clean($item['os']) ?> <?= clean($item['os_version']) ?></td></tr>
                    <tr><th class="text-muted">WiFi MAC</th><td><?= $item['wifi_mac'] ? '<code>' . clean($item['wifi_mac']) . '</code>' : '-' ?></td></tr>
                    <tr><th class="text-muted">Cellular</th><td><?= $item['cellular'] ? '<span class="badge bg-success">Da</span>' : '<span class="badge bg-secondary">Ne</span>' ?></td></tr>
                    <tr><th class="text-muted">Tel. broj</th><td><?= clean($item['phone_number']) ?: '-' ?></td></tr>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-header bg-white"><h6 class="mb-0">Dodjela & Jamstvo</h6></div>
            <div class="card-body">
                <table class="table table-sm">
                    <tr><th class="text-muted" style="width:35%">Asset tag</th><td><?= clean($item['asset_tag']) ?: '-' ?></td></tr>
                    <tr><th class="text-muted">Dodijeljen</th><td><?= clean($item['assigned_to']) ?: '-' ?></td></tr>
                    <tr><th class="text-muted">Odjel</th><td><?= clean($item['department']) ?: '-' ?></td></tr>
                    <tr><th class="text-muted">Datum kupnje</th><td><?= formatDate($item['purchase_date']) ?></td></tr>
                    <tr><th class="text-muted">Jamstvo do</th><td><?= formatDate($item['warranty_until']) ?></td></tr>
                </table>
            </div>
        </div>
    </div>
</div>
<?php if ($item['notes']): ?><div class="card"><div class="card-header bg-white"><h6 class="mb-0">Napomene</h6></div><div class="card-body"><?= nl2br(clean($item['notes'])) ?></div></div><?php endif; ?>
<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
