<?php
require_once __DIR__ . '/../../includes/header.php';
requireLogin();

$db = getDB();
$stmt = $db->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$_GET['id'] ?? 0]);
$user = $stmt->fetch();

if (!$user) { 
    setFlash('error', 'Korisnik nije pronađen.'); 
    header('Location: index.php'); 
    exit; 
}

$pageTitle = $user['full_name'] . ' - IT Inventory';
$currentPage = 'users';

// Dohvati uređaje korisnika
$pcs = $db->prepare("SELECT * FROM pcs WHERE user_id = ?"); $pcs->execute([$user['id']]); $pcs = $pcs->fetchAll();
$laptops = $db->prepare("SELECT * FROM laptops WHERE user_id = ?"); $laptops->execute([$user['id']]); $laptops = $laptops->fetchAll();
$tablets = $db->prepare("SELECT * FROM tablets WHERE user_id = ?"); $tablets->execute([$user['id']]); $tablets = $tablets->fetchAll();
$phones = $db->prepare("SELECT * FROM phones WHERE user_id = ?"); $phones->execute([$user['id']]); $phones = $phones->fetchAll();
$totalDevices = count($laptops) + count($pcs) + count($tablets) + count($phones);
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4><i class="bi bi-person me-2"></i><?= clean($user['full_name']) ?> <?= statusBadge($user['status']) ?></h4>
        <p class="text-muted mb-0"><?= clean($user['username']) ?> · <?= clean($user['email']) ?></p>
    </div>
    <div>
        <a href="credential-sheet.php?id=<?= $user['id'] ?>" class="btn btn-outline-info" target="_blank"><i class="bi bi-file-text me-1"></i>Credential Sheet</a>
        <a href="edit.php?id=<?= $user['id'] ?>" class="btn btn-outline-primary"><i class="bi bi-pencil me-1"></i>Uredi</a>
        <a href="index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-1"></i>Natrag</a>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-header bg-white"><h6 class="mb-0">Informacije</h6></div>
            <div class="card-body">
                <table class="table table-sm">
                    <tr><th class="text-muted" style="width:35%">Odjel</th><td><?= clean($user['department']) ?: '-' ?></td></tr>
                    <tr><th class="text-muted">Pozicija</th><td><?= clean($user['position']) ?: '-' ?></td></tr>
                    <tr><th class="text-muted">Email</th><td><?= clean($user['email']) ?: '-' ?></td></tr>
                    <tr><th class="text-muted">Telefon</th><td><?= clean($user['phone']) ?: '-' ?></td></tr>
                    <tr><th class="text-muted">Službeni mob.</th><td><?= clean($user['work_phone']) ?: '-' ?></td></tr>
                    <tr><th class="text-muted">Privatni mob.</th><td><?= clean($user['private_phone']) ?: '-' ?></td></tr>
                    <tr><th class="text-muted">Kreiran</th><td><?= formatDateTime($user['created_at']) ?></td></tr>
                </table>
            </div>
        </div>
        
        <div class="card mb-4">
            <div class="card-header bg-white"><h6 class="mb-0">Servisi i pristupni podaci</h6></div>
            <div class="card-body">
                <table class="table table-sm">
                    <tr>
                        <th class="text-muted" style="width:35%">Active Directory</th>
                        <td>
                            <?= $user['ad_enabled'] ? '<span class="badge bg-success">Uključen</span>' : '<span class="badge bg-secondary">Isključen</span>' ?>
                            <?php if ($user['ad_enabled'] && $user['ad_password']): ?>
                            <br><small class="text-muted">Pass: <code class="user-select-all"><?= clean($user['ad_password']) ?></code></small>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <th class="text-muted">Zimbra</th>
                        <td>
                            <?= $user['zimbra_enabled'] ? '<span class="badge bg-success">Uključen</span>' : '<span class="badge bg-secondary">Isključen</span>' ?>
                            <?= $user['zimbra_enabled'] && $user['zimbra_quota_gb'] ? '<small class="text-muted ms-2">(' . $user['zimbra_quota_gb'] . ' GB)</small>' : '' ?>
                            <?php if ($user['zimbra_enabled'] && $user['zimbra_password']): ?>
                            <br><small class="text-muted">Pass: <code class="user-select-all"><?= clean($user['zimbra_password']) ?></code></small>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <th class="text-muted">Nextcloud</th>
                        <td>
                            <?= $user['nextcloud_enabled'] ? '<span class="badge bg-success">Uključen</span>' : '<span class="badge bg-secondary">Isključen</span>' ?>
                            <?= $user['nextcloud_enabled'] && $user['nextcloud_quota_gb'] ? '<small class="text-muted ms-2">(' . $user['nextcloud_quota_gb'] . ' GB)</small>' : '' ?>
                            <?php if ($user['nextcloud_enabled'] && $user['nextcloud_password']): ?>
                            <br><small class="text-muted">Pass: <code class="user-select-all"><?= clean($user['nextcloud_password']) ?></code></small>
                            <?php endif; ?>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-header bg-white d-flex justify-content-between align-items-center">
                <h6 class="mb-0"><i class="bi bi-device-hdd me-2"></i>Dodijeljeni uređaji (<?= $totalDevices ?>)</h6>
            </div>
            <div class="card-body">
                <?php if ($totalDevices === 0): ?>
                <p class="text-muted mb-0">Nema dodijeljenih uređaja</p>
                <?php else: ?>
                
                <?php if ($pcs): ?>
                <h6 class="text-muted small mb-2"><i class="bi bi-pc-display-horizontal me-1"></i>PC računala</h6>
                <ul class="list-unstyled mb-3">
                    <?php foreach ($pcs as $d): ?>
                    <li class="mb-1">
                        <a href="<?= APP_URL ?>/modules/pcs/view.php?id=<?= $d['id'] ?>"><?= clean($d['name']) ?></a>
                        <small class="text-muted">- <?= clean($d['manufacturer']) ?> <?= clean($d['model']) ?></small>
                        <?php if ($d['ip_address']): ?><br><small class="text-muted">IP: <?= clean($d['ip_address']) ?></small><?php endif; ?>
                    </li>
                    <?php endforeach; ?>
                </ul>
                <?php endif; ?>
                
                <?php if ($laptops): ?>
                <h6 class="text-muted small mb-2"><i class="bi bi-laptop me-1"></i>Laptopi</h6>
                <ul class="list-unstyled mb-3">
                    <?php foreach ($laptops as $d): ?>
                    <li class="mb-1">
                        <a href="<?= APP_URL ?>/modules/laptops/view.php?id=<?= $d['id'] ?>"><?= clean($d['name']) ?></a>
                        <small class="text-muted">- <?= clean($d['manufacturer']) ?> <?= clean($d['model']) ?></small>
                        <?php if ($d['ip_address']): ?><br><small class="text-muted">IP: <?= clean($d['ip_address']) ?></small><?php endif; ?>
                    </li>
                    <?php endforeach; ?>
                </ul>
                <?php endif; ?>
                
                <?php if ($tablets): ?>
                <h6 class="text-muted small mb-2"><i class="bi bi-tablet me-1"></i>Tableti</h6>
                <ul class="list-unstyled mb-3">
                    <?php foreach ($tablets as $d): ?>
                    <li class="mb-1">
                        <a href="<?= APP_URL ?>/modules/tablets/view.php?id=<?= $d['id'] ?>"><?= clean($d['name']) ?></a>
                        <small class="text-muted">- <?= clean($d['manufacturer']) ?> <?= clean($d['model']) ?></small>
                        <?php if ($d['phone_number']): ?><br><small class="text-muted">Tel: <?= clean($d['phone_number']) ?></small><?php endif; ?>
                    </li>
                    <?php endforeach; ?>
                </ul>
                <?php endif; ?>
                
                <?php if ($phones): ?>
                <h6 class="text-muted small mb-2"><i class="bi bi-phone me-1"></i>Mobiteli</h6>
                <ul class="list-unstyled mb-0">
                    <?php foreach ($phones as $d): ?>
                    <li class="mb-1">
                        <a href="<?= APP_URL ?>/modules/phones/view.php?id=<?= $d['id'] ?>"><?= clean($d['name']) ?></a>
                        <small class="text-muted">- <?= clean($d['manufacturer']) ?> <?= clean($d['model']) ?></small>
                        <?php if ($d['phone_number']): ?><br><small class="text-muted">Tel: <?= clean($d['phone_number']) ?></small><?php endif; ?>
                    </li>
                    <?php endforeach; ?>
                </ul>
                <?php endif; ?>
                
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php if ($user['notes']): ?>
<div class="card">
    <div class="card-header bg-white"><h6 class="mb-0">Napomene</h6></div>
    <div class="card-body"><?= nl2br(clean($user['notes'])) ?></div>
</div>
<?php endif; ?>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
