<?php
/**
 * IT Inventory - Virtual Machines List
 */
$pageTitle = 'Virtualne mašine - IT Inventory';
$currentPage = 'vms';

require_once __DIR__ . '/../../includes/header.php';
requireLogin();

$db = getDB();

// Pretraga i filtriranje
$search = $_GET['search'] ?? '';
$status = $_GET['status'] ?? '';
$serverId = $_GET['server_id'] ?? '';

$where = [];
$params = [];

if ($search) {
    $where[] = "(v.name LIKE ? OR v.ip_address LIKE ? OR v.purpose LIKE ?)";
    $searchTerm = "%{$search}%";
    $params = array_merge($params, [$searchTerm, $searchTerm, $searchTerm]);
}

if ($status) {
    $where[] = "v.status = ?";
    $params[] = $status;
}

if ($serverId) {
    $where[] = "v.server_id = ?";
    $params[] = $serverId;
}

$whereClause = $where ? 'WHERE ' . implode(' AND ', $where) : '';

$sql = "
    SELECT v.*, s.name as server_name
    FROM virtual_machines v
    LEFT JOIN servers s ON v.server_id = s.id
    {$whereClause}
    ORDER BY s.name, v.name
";

$stmt = $db->prepare($sql);
$stmt->execute($params);
$vms = $stmt->fetchAll();

// Dohvati servere za filter
$servers = $db->query("SELECT id, name FROM servers ORDER BY name")->fetchAll();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4><i class="bi bi-pc-display me-2"></i>Virtualne mašine</h4>
    <a href="add.php" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i>Nova VM
    </a>
</div>

<!-- Filters -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-4">
                <div class="search-box">
                    <i class="bi bi-search"></i>
                    <input type="text" name="search" class="form-control" placeholder="Pretraži..." value="<?= clean($search) ?>">
                </div>
            </div>
            <div class="col-md-3">
                <select name="server_id" class="form-select">
                    <option value="">Svi serveri</option>
                    <?php foreach ($servers as $s): ?>
                    <option value="<?= $s['id'] ?>" <?= $serverId == $s['id'] ? 'selected' : '' ?>><?= clean($s['name']) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-3">
                <select name="status" class="form-select">
                    <option value="">Svi statusi</option>
                    <option value="running" <?= $status === 'running' ? 'selected' : '' ?>>Running</option>
                    <option value="stopped" <?= $status === 'stopped' ? 'selected' : '' ?>>Stopped</option>
                    <option value="suspended" <?= $status === 'suspended' ? 'selected' : '' ?>>Suspended</option>
                    <option value="template" <?= $status === 'template' ? 'selected' : '' ?>>Template</option>
                </select>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-outline-secondary w-100">Filtriraj</button>
            </div>
        </form>
    </div>
</div>

<!-- VM List -->
<div class="card">
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>VMID</th>
                    <th>Naziv</th>
                    <th>Server</th>
                    <th>IP</th>
                    <th>OS</th>
                    <th>Resursi</th>
                    <th>Status</th>
                    <th class="text-end">Akcije</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($vms)): ?>
                <tr>
                    <td colspan="8" class="text-center text-muted py-4">
                        <i class="bi bi-inbox display-6 d-block mb-2"></i>
                        Nema virtualnih mašina
                    </td>
                </tr>
                <?php else: ?>
                <?php foreach ($vms as $vm): ?>
                <tr>
                    <td><code><?= $vm['vmid'] ?: '-' ?></code></td>
                    <td>
                        <a href="view.php?id=<?= $vm['id'] ?>" class="fw-bold text-decoration-none">
                            <?= clean($vm['name']) ?>
                        </a>
                        <?php if ($vm['purpose']): ?>
                        <br><small class="text-muted"><?= clean($vm['purpose']) ?></small>
                        <?php endif; ?>
                    </td>
                    <td>
                        <a href="<?= APP_URL ?>/modules/servers/view.php?id=<?= $vm['server_id'] ?>" class="text-decoration-none">
                            <?= clean($vm['server_name']) ?>
                        </a>
                    </td>
                    <td>
                        <?php if ($vm['ip_address']): ?>
                        <code><?= clean($vm['ip_address']) ?></code>
                        <button class="btn btn-sm btn-link p-0 ms-1" data-copy="<?= clean($vm['ip_address']) ?>" title="Kopiraj">
                            <i class="bi bi-clipboard"></i>
                        </button>
                        <?php else: ?>
                        -
                        <?php endif; ?>
                    </td>
                    <td><?= clean($vm['os']) ?: '-' ?></td>
                    <td>
                        <small>
                            <?= $vm['cpu_cores'] ?>C / <?= formatSize($vm['ram_gb']) ?> / <?= formatSize($vm['disk_gb']) ?>
                        </small>
                    </td>
                    <td><?= statusBadge($vm['status']) ?></td>
                    <td class="text-end">
                        <a href="view.php?id=<?= $vm['id'] ?>" class="btn btn-sm btn-outline-primary" title="Detalji">
                            <i class="bi bi-eye"></i>
                        </a>
                        <a href="edit.php?id=<?= $vm['id'] ?>" class="btn btn-sm btn-outline-secondary" title="Uredi">
                            <i class="bi bi-pencil"></i>
                        </a>
                        <a href="delete.php?id=<?= $vm['id'] ?>" class="btn btn-sm btn-outline-danger" title="Obriši" data-confirm="Jeste li sigurni?">
                            <i class="bi bi-trash"></i>
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
