<?php
require_once __DIR__ . '/config.php';
$pageTitle = 'Mrežni dijagram - ' . APP_NAME;
$currentPage = 'diagram';

require_once __DIR__ . '/includes/header.php';
requireLogin();

$db = getDB();

$servers = $db->query("SELECT * FROM servers WHERE status != 'retired' ORDER BY name")->fetchAll();

$vmsByServer = [];
foreach ($servers as $server) {
    try {
        $stmt = $db->prepare("SELECT * FROM virtual_machines WHERE server_id = ? ORDER BY name");
        $stmt->execute([$server['id']]);
        $vmsByServer[$server['id']] = $stmt->fetchAll();
    } catch (PDOException $e) {
        $vmsByServer[$server['id']] = [];
    }
}

$equipment = [];
try {
    $equipment = $db->query("SELECT * FROM equipment WHERE status = 'active' ORDER BY type, name")->fetchAll();
} catch (PDOException $e) {}

$typeIcons = [
    'switch' => 'bi-diagram-3',
    'router' => 'bi-router',
    'firewall' => 'bi-shield-lock',
    'ups' => 'bi-battery-charging',
    'storage' => 'bi-device-hdd',
    'nas' => 'bi-hdd-stack',
    'san' => 'bi-hdd-network',
    'ap' => 'bi-wifi',
    'other' => 'bi-box'
];
?>

<style>
.diagram-section {
    margin-bottom: 2rem;
}

.diagram-section-title {
    color: var(--text-muted);
    font-size: 0.75rem;
    text-transform: uppercase;
    letter-spacing: 0.1em;
    margin-bottom: 1rem;
    padding-left: 0.5rem;
    border-left: 3px solid var(--primary);
}

.server-node {
    background: var(--bg-card);
    border: 1px solid var(--border-color);
    border-radius: 16px;
    padding: 1.25rem;
    margin-bottom: 1rem;
    transition: all 0.3s ease;
    cursor: pointer;
}

.server-node:hover {
    border-color: var(--primary);
    box-shadow: var(--glow-primary);
}

.server-node.expanded {
    border-color: var(--primary);
}

.server-header {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.server-icon {
    width: 48px;
    height: 48px;
    background: linear-gradient(135deg, rgba(0, 212, 255, 0.2), rgba(124, 58, 237, 0.1));
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    color: var(--primary);
}

.server-info h5 {
    margin: 0;
    font-size: 1rem;
    font-weight: 600;
}

.server-info p {
    color: var(--text-muted);
    margin: 0;
    font-size: 0.8rem;
}

.server-stats {
    display: flex;
    gap: 1rem;
    margin-left: auto;
}

.server-stat {
    text-align: center;
    padding: 0.5rem 1rem;
    background: rgba(0, 212, 255, 0.05);
    border-radius: 8px;
    border: 1px solid var(--border-color);
}

.server-stat-value {
    color: var(--primary);
    font-weight: 700;
    font-size: 1.1rem;
}

.server-stat-label {
    color: var(--text-muted);
    font-size: 0.7rem;
    text-transform: uppercase;
}

.vm-list {
    margin-top: 1rem;
    padding-top: 1rem;
    border-top: 1px solid var(--border-color);
    display: none;
}

.server-node.expanded .vm-list {
    display: block;
}

.vm-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(220px, 1fr));
    gap: 0.75rem;
}

.vm-node {
    background: rgba(0, 212, 255, 0.03);
    border: 1px solid var(--border-color);
    border-radius: 10px;
    padding: 0.875rem;
    display: flex;
    align-items: center;
    gap: 0.75rem;
    transition: all 0.2s;
    text-decoration: none;
    color: inherit;
}

.vm-node:hover {
    background: rgba(0, 212, 255, 0.08);
    border-color: var(--primary);
    color: inherit;
}

.vm-icon {
    width: 36px;
    height: 36px;
    background: linear-gradient(135deg, rgba(16, 185, 129, 0.2), rgba(16, 185, 129, 0.05));
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--accent);
    font-size: 1rem;
}

.vm-info h6 {
    margin: 0;
    font-size: 0.875rem;
    font-weight: 600;
}

.vm-info small {
    color: var(--text-muted);
    font-size: 0.75rem;
}

.vm-status {
    margin-left: auto;
    width: 10px;
    height: 10px;
    border-radius: 50%;
    background: var(--success);
    box-shadow: 0 0 10px var(--success);
}

.vm-status.stopped { background: var(--text-muted); box-shadow: none; }
.vm-status.maintenance { background: var(--warning); box-shadow: 0 0 10px var(--warning); }

.equipment-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(180px, 1fr));
    gap: 1rem;
}

.equipment-node {
    background: var(--bg-card);
    border: 1px solid var(--border-color);
    border-radius: 12px;
    padding: 1.25rem;
    text-align: center;
    transition: all 0.3s;
    text-decoration: none;
    color: inherit;
}

.equipment-node:hover {
    border-color: var(--accent);
    box-shadow: var(--glow-green);
    color: inherit;
}

.equipment-icon {
    width: 48px;
    height: 48px;
    margin: 0 auto 0.75rem;
    background: linear-gradient(135deg, rgba(16, 185, 129, 0.2), rgba(16, 185, 129, 0.05));
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    color: var(--accent);
}

.equipment-node h6 {
    margin: 0 0 0.25rem;
    font-size: 0.9rem;
}

.equipment-node small {
    color: var(--text-muted);
    font-size: 0.75rem;
}

.expand-btn {
    color: var(--text-muted);
    margin-left: 1rem;
    transition: transform 0.3s;
}

.server-node.expanded .expand-btn i {
    transform: rotate(180deg);
}

.diagram-legend {
    display: flex;
    flex-wrap: wrap;
    gap: 1.5rem;
    padding: 1rem 1.25rem;
    background: var(--bg-card);
    border: 1px solid var(--border-color);
    border-radius: 12px;
    margin-bottom: 1.5rem;
}

.legend-item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    color: var(--text-secondary);
    font-size: 0.8rem;
}

.legend-dot {
    width: 10px;
    height: 10px;
    border-radius: 50%;
}

.legend-dot.running { background: var(--success); }
.legend-dot.stopped { background: var(--text-muted); }
.legend-dot.maintenance { background: var(--warning); }

@media print {
    .server-node.expanded .vm-list { display: block !important; }
}
</style>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4><i class="bi bi-diagram-3 me-2"></i>Mrežni dijagram</h4>
    <div>
        <button class="btn btn-outline-secondary" onclick="expandAll()"><i class="bi bi-arrows-expand me-1"></i>Proširi sve</button>
        <button class="btn btn-outline-secondary" onclick="collapseAll()"><i class="bi bi-arrows-collapse me-1"></i>Skupi sve</button>
        <button class="btn btn-outline-primary" onclick="window.print()"><i class="bi bi-printer me-1"></i>Ispiši</button>
    </div>
</div>

<div class="diagram-legend">
    <div class="legend-item"><div class="legend-dot running"></div> Running</div>
    <div class="legend-item"><div class="legend-dot stopped"></div> Stopped</div>
    <div class="legend-item"><div class="legend-dot maintenance"></div> Maintenance</div>
    <div class="legend-item"><i class="bi bi-server me-1" style="color:var(--primary)"></i> Fizički server</div>
    <div class="legend-item"><i class="bi bi-pc-display me-1" style="color:var(--accent)"></i> Virtualni server</div>
</div>

<?php if (!empty($equipment)): ?>
<div class="diagram-section">
    <div class="diagram-section-title">Mrežna oprema</div>
    <div class="equipment-grid">
        <?php foreach ($equipment as $eq): ?>
        <a href="<?= APP_URL ?>/modules/equipment/view.php?id=<?= $eq['id'] ?>" class="equipment-node">
            <div class="equipment-icon">
                <i class="bi <?= $typeIcons[$eq['type'] ?? 'other'] ?? 'bi-box' ?>"></i>
            </div>
            <h6><?= clean($eq['name'] ?? '') ?></h6>
            <small><?= clean($eq['model'] ?? '') ?></small>
            <?php if (!empty($eq['ip_address'])): ?>
            <br><code style="font-size:0.7rem"><?= clean($eq['ip_address']) ?></code>
            <?php endif; ?>
        </a>
        <?php endforeach; ?>
    </div>
</div>
<?php endif; ?>

<div class="diagram-section">
    <div class="diagram-section-title">Serveri &amp; Virtualne mašine</div>
    
    <?php foreach ($servers as $server): ?>
    <?php $vms = $vmsByServer[$server['id']] ?? []; ?>
    <div class="server-node" onclick="toggleServer(this)">
        <div class="server-header">
            <div class="server-icon">
                <i class="bi bi-server"></i>
            </div>
            <div class="server-info">
                <h5><?= clean($server['name'] ?? '') ?></h5>
                <p>
                    <?= clean($server['cpu'] ?? '') ?>
                    <?php if (!empty($server['ip_address'])): ?> · <code><?= clean($server['ip_address']) ?></code><?php endif; ?>
                </p>
            </div>
            <div class="server-stats">
                <div class="server-stat">
                    <div class="server-stat-value"><?= $server['ram_gb'] ?? '-' ?></div>
                    <div class="server-stat-label">RAM GB</div>
                </div>
                <div class="server-stat">
                    <div class="server-stat-value"><?= count($vms) ?></div>
                    <div class="server-stat-label">VM</div>
                </div>
            </div>
            <span class="expand-btn"><i class="bi bi-chevron-down"></i></span>
        </div>
        
        <?php if (!empty($vms)): ?>
        <div class="vm-list">
            <div class="vm-grid">
                <?php foreach ($vms as $vm): ?>
                <a href="<?= APP_URL ?>/modules/vms/view.php?id=<?= $vm['id'] ?>" class="vm-node" onclick="event.stopPropagation()">
                    <div class="vm-icon">
                        <i class="bi bi-pc-display"></i>
                    </div>
                    <div class="vm-info">
                        <h6><?= clean($vm['name'] ?? '') ?></h6>
                        <small><?= $vm['cpu_cores'] ?? 1 ?> vCPU · <?= $vm['ram_gb'] ?? 0 ?> GB · <?= clean($vm['ip_address'] ?? '') ?></small>
                    </div>
                    <div class="vm-status <?= ($vm['status'] ?? '') === 'running' ? '' : (($vm['status'] ?? '') === 'maintenance' ? 'maintenance' : 'stopped') ?>"></div>
                </a>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
    <?php endforeach; ?>
    
    <?php if (empty($servers)): ?>
    <div class="text-center py-5">
        <i class="bi bi-server display-4 mb-3 d-block" style="color:var(--text-muted)"></i>
        <p class="text-muted">Nema servera za prikaz</p>
    </div>
    <?php endif; ?>
</div>

<script>
function toggleServer(node) { node.classList.toggle('expanded'); }
function expandAll() { document.querySelectorAll('.server-node').forEach(n => n.classList.add('expanded')); }
function collapseAll() { document.querySelectorAll('.server-node').forEach(n => n.classList.remove('expanded')); }
document.addEventListener('DOMContentLoaded', function() {
    const first = document.querySelector('.server-node');
    if (first) first.classList.add('expanded');
});
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
