<?php
$pageTitle = 'Dashboard - IT Inventory';
$currentPage = 'dashboard';

require_once __DIR__ . '/includes/header.php';
requireLogin();

$db = getDB();

// Funkcija za siguran COUNT upit
function safeCount($db, $table, $whereStatus = false) {
    try {
        if ($whereStatus) {
            return $db->query("SELECT COUNT(*) FROM {$table} WHERE status = 'active'")->fetchColumn();
        }
        return $db->query("SELECT COUNT(*) FROM {$table}")->fetchColumn();
    } catch (PDOException $e) {
        return 0;
    }
}

// Statistike
$stats = [
    'servers' => safeCount($db, 'servers'),
    'vms' => safeCount($db, 'virtual_machines'),
    'users' => safeCount($db, 'users', true),
    'printers' => safeCount($db, 'printers'),
    'pcs' => safeCount($db, 'pcs', true),
    'laptops' => safeCount($db, 'laptops', true),
    'tablets' => safeCount($db, 'tablets', true),
    'phones' => safeCount($db, 'phones', true),
];

// Zadnjih 10 promjena
$changelog = [];
try {
    $changelog = $db->query("SELECT * FROM changelog ORDER BY created_at DESC LIMIT 10")->fetchAll();
} catch (PDOException $e) {}

// Jamstva koja ističu u 30 dana
$expiringWarranties = [];
try {
    $result = $db->query("SELECT 'laptop' as type, name, warranty_until FROM laptops WHERE warranty_until BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 30 DAY) LIMIT 5");
    $expiringWarranties = array_merge($expiringWarranties, $result->fetchAll());
} catch (PDOException $e) {}

try {
    $result = $db->query("SELECT 'pc' as type, name, warranty_until FROM pcs WHERE warranty_until BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 30 DAY) LIMIT 5");
    $expiringWarranties = array_merge($expiringWarranties, $result->fetchAll());
} catch (PDOException $e) {}

try {
    $result = $db->query("SELECT 'phone' as type, name, warranty_until FROM phones WHERE warranty_until BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 30 DAY) LIMIT 5");
    $expiringWarranties = array_merge($expiringWarranties, $result->fetchAll());
} catch (PDOException $e) {}

// Licencije maknute
$expiringLicenses = [];
?>

<div class="page-header">
    <h4><i class="bi bi-speedometer2"></i>Dashboard</h4>
    <div class="text-muted">
        <i class="bi bi-calendar3 me-1"></i><?= date('d.m.Y. H:i') ?>
    </div>
</div>

<!-- Stats Grid -->
<div class="row g-4 mb-4">
    <div class="col-6 col-md-4 col-xl-3">
        <a href="<?= APP_URL ?>/modules/servers/" class="stat-card">
            <div class="stat-icon primary"><i class="bi bi-server"></i></div>
            <div class="stat-content">
                <h3><?= $stats['servers'] ?></h3>
                <p>Serveri</p>
            </div>
        </a>
    </div>
    <div class="col-6 col-md-4 col-xl-3">
        <a href="<?= APP_URL ?>/modules/vms/" class="stat-card">
            <div class="stat-icon info"><i class="bi bi-pc-display"></i></div>
            <div class="stat-content">
                <h3><?= $stats['vms'] ?></h3>
                <p>Virtualke</p>
            </div>
        </a>
    </div>
    <div class="col-6 col-md-4 col-xl-3">
        <a href="<?= APP_URL ?>/modules/users/" class="stat-card">
            <div class="stat-icon success"><i class="bi bi-people"></i></div>
            <div class="stat-content">
                <h3><?= $stats['users'] ?></h3>
                <p>Korisnici</p>
            </div>
        </a>
    </div>
    <div class="col-6 col-md-4 col-xl-3">
        <a href="<?= APP_URL ?>/modules/printers/" class="stat-card">
            <div class="stat-icon warning"><i class="bi bi-printer"></i></div>
            <div class="stat-content">
                <h3><?= $stats['printers'] ?></h3>
                <p>Printeri</p>
            </div>
        </a>
    </div>
</div>

<!-- Devices Row -->
<div class="row g-4 mb-4">
    <div class="col-6 col-md-3">
        <a href="<?= APP_URL ?>/modules/pcs/" class="stat-card">
            <div class="stat-icon primary"><i class="bi bi-pc-display-horizontal"></i></div>
            <div class="stat-content">
                <h3><?= $stats['pcs'] ?></h3>
                <p>PC računala</p>
            </div>
        </a>
    </div>
    <div class="col-6 col-md-3">
        <a href="<?= APP_URL ?>/modules/laptops/" class="stat-card">
            <div class="stat-icon info"><i class="bi bi-laptop"></i></div>
            <div class="stat-content">
                <h3><?= $stats['laptops'] ?></h3>
                <p>Laptopi</p>
            </div>
        </a>
    </div>
    <div class="col-6 col-md-3">
        <a href="<?= APP_URL ?>/modules/tablets/" class="stat-card">
            <div class="stat-icon success"><i class="bi bi-tablet"></i></div>
            <div class="stat-content">
                <h3><?= $stats['tablets'] ?></h3>
                <p>Tableti</p>
            </div>
        </a>
    </div>
    <div class="col-6 col-md-3">
        <a href="<?= APP_URL ?>/modules/phones/" class="stat-card">
            <div class="stat-icon danger"><i class="bi bi-phone"></i></div>
            <div class="stat-content">
                <h3><?= $stats['phones'] ?></h3>
                <p>Mobiteli</p>
            </div>
        </a>
    </div>
</div>

<div class="row g-4">
    <!-- Aktivnost -->
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h6><i class="bi bi-activity me-2"></i>Nedavna aktivnost</h6>
                <a href="<?= APP_URL ?>/changelog.php" class="btn btn-sm btn-outline-primary">Vidi sve</a>
            </div>
            <div class="card-body p-0">
                <?php if (empty($changelog)): ?>
                <div class="empty-state">
                    <i class="bi bi-clock-history"></i>
                    <p>Nema zabilježenih aktivnosti</p>
                </div>
                <?php else: ?>
                <div class="table-responsive">
                    <table class="table">
                        <tbody>
                            <?php foreach ($changelog as $log): ?>
                            <tr>
                                <td style="width:50px">
                                    <?php
                                    $icon = match($log['action'] ?? '') {
                                        'create' => '<span class="badge bg-success"><i class="bi bi-plus-lg"></i></span>',
                                        'update' => '<span class="badge bg-info"><i class="bi bi-pencil"></i></span>',
                                        'delete' => '<span class="badge bg-danger"><i class="bi bi-trash"></i></span>',
                                        default => '<span class="badge bg-secondary"><i class="bi bi-dot"></i></span>'
                                    };
                                    echo $icon;
                                    ?>
                                </td>
                                <td>
                                    <strong><?= clean($log['entity_name'] ?? '') ?></strong>
                                    <br><small class="text-muted"><?= ucfirst($log['entity_type'] ?? '') ?></small>
                                </td>
                                <td class="text-muted">
                                    <small>
                                        <i class="bi bi-person me-1"></i><?= clean($log['admin_name'] ?? '') ?>
                                    </small>
                                </td>
                                <td class="text-end text-muted">
                                    <small><?= formatDateTime($log['created_at'] ?? '') ?></small>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <!-- Upozorenja -->
    <div class="col-lg-4">
        <?php if (!empty($expiringWarranties)): ?>
        <div class="card mb-4">
            <div class="card-header">
                <h6><i class="bi bi-exclamation-triangle text-warning me-2"></i>Jamstva ističu</h6>
            </div>
            <div class="card-body">
                <ul class="device-list">
                    <?php foreach ($expiringWarranties as $w): ?>
                    <li>
                        <div class="device-icon">
                            <i class="bi bi-<?= $w['type'] === 'laptop' ? 'laptop' : ($w['type'] === 'phone' ? 'phone' : 'pc-display-horizontal') ?>"></i>
                        </div>
                        <div class="flex-grow-1">
                            <strong><?= clean($w['name']) ?></strong>
                            <br><small class="text-danger"><?= formatDate($w['warranty_until']) ?></small>
                        </div>
                    </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
        <?php endif; ?>
        
    </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
