<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/functions.php';
require_once __DIR__ . '/../../includes/auth.php';

if (session_status() === PHP_SESSION_NONE) { session_name(SESSION_NAME); session_start(); }
if (!isLoggedIn()) { header('Location: ' . APP_URL . '/login.php'); exit; }

$isEdit = isset($_GET['id']);
$db = getDB();
$item = null;
$errors = [];

$typeLabels = [
    'switch' => 'Switch',
    'router' => 'Router', 
    'firewall' => 'Firewall',
    'ups' => 'UPS',
    'storage' => 'Storage',
    'nas' => 'NAS',
    'san' => 'SAN',
    'ap' => 'Access Point',
    'other' => 'Ostalo'
];

if ($isEdit) {
    $stmt = $db->prepare("SELECT * FROM equipment WHERE id = ?");
    $stmt->execute([$_GET['id']]);
    $item = $stmt->fetch();
    if (!$item) { setFlash('error', 'Oprema nije pronađena.'); header('Location: index.php'); exit; }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verifyCSRF($_POST['csrf_token'] ?? '')) { $errors[] = 'Nevažeći CSRF token.'; }
    
    $data = [
        'name' => trim($_POST['name'] ?? ''),
        'type' => $_POST['type'] ?? 'other',
        'asset_tag' => trim($_POST['asset_tag'] ?? ''),
        'manufacturer' => trim($_POST['manufacturer'] ?? ''),
        'model' => trim($_POST['model'] ?? ''),
        'serial_number' => trim($_POST['serial_number'] ?? ''),
        'ip_address' => trim($_POST['ip_address'] ?? ''),
        'mac_address' => trim($_POST['mac_address'] ?? ''),
        'location' => trim($_POST['location'] ?? ''),
        'rack_position' => trim($_POST['rack_position'] ?? ''),
        'ports_count' => (int)($_POST['ports_count'] ?? 0) ?: null,
        'purchase_date' => $_POST['purchase_date'] ?: null,
        'warranty_until' => $_POST['warranty_until'] ?: null,
        'status' => $_POST['status'] ?? 'active',
        'notes' => trim($_POST['notes'] ?? '')
    ];
    
    if (empty($data['name'])) $errors[] = 'Naziv je obavezan.';
    
    if (empty($errors)) {
        try {
            if ($isEdit) {
                $stmt = $db->prepare("UPDATE equipment SET name=?, type=?, asset_tag=?, manufacturer=?, model=?, serial_number=?, ip_address=?, mac_address=?, location=?, rack_position=?, ports_count=?, purchase_date=?, warranty_until=?, status=?, notes=? WHERE id=?");
                $stmt->execute([$data['name'], $data['type'], $data['asset_tag'], $data['manufacturer'], $data['model'], $data['serial_number'], $data['ip_address'], $data['mac_address'], $data['location'], $data['rack_position'], $data['ports_count'], $data['purchase_date'], $data['warranty_until'], $data['status'], $data['notes'], $_GET['id']]);
                logChange('update', 'equipment', $_GET['id'], $data['name'], $item, $data);
                setFlash('success', 'Oprema je ažurirana.');
            } else {
                $stmt = $db->prepare("INSERT INTO equipment (name, type, asset_tag, manufacturer, model, serial_number, ip_address, mac_address, location, rack_position, ports_count, purchase_date, warranty_until, status, notes) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                $stmt->execute([$data['name'], $data['type'], $data['asset_tag'], $data['manufacturer'], $data['model'], $data['serial_number'], $data['ip_address'], $data['mac_address'], $data['location'], $data['rack_position'], $data['ports_count'], $data['purchase_date'], $data['warranty_until'], $data['status'], $data['notes']]);
                logChange('create', 'equipment', $db->lastInsertId(), $data['name'], null, $data);
                setFlash('success', 'Oprema je dodana.');
            }
            header('Location: index.php'); exit;
        } catch (PDOException $e) { $errors[] = 'Greška: ' . $e->getMessage(); }
    }
    $item = $data;
}

$pageTitle = ($isEdit ? 'Uredi' : 'Nova') . ' oprema - IT Inventory';
$currentPage = 'equipment';
require_once __DIR__ . '/../../includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4><i class="bi bi-diagram-3 me-2"></i><?= $isEdit ? 'Uredi: ' . clean($item['name']) : 'Nova oprema' ?></h4>
    <a href="index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-1"></i>Natrag</a>
</div>

<?php if ($errors): ?><div class="alert alert-danger"><ul class="mb-0"><?php foreach ($errors as $e): ?><li><?= clean($e) ?></li><?php endforeach; ?></ul></div><?php endif; ?>

<div class="card">
    <div class="card-body">
        <form method="POST">
            <input type="hidden" name="csrf_token" value="<?= generateCSRF() ?>">
            <div class="row">
                <div class="col-md-6">
                    <h6 class="text-muted mb-3">Osnovni podaci</h6>
                    <div class="row">
                        <div class="col-8 mb-3">
                            <label class="form-label required">Naziv</label>
                            <input type="text" name="name" class="form-control" value="<?= clean($item['name'] ?? '') ?>" required>
                        </div>
                        <div class="col-4 mb-3">
                            <label class="form-label required">Tip</label>
                            <select name="type" class="form-select">
                                <?php foreach ($typeLabels as $k => $v): ?>
                                <option value="<?= $k ?>" <?= ($item['type'] ?? 'other') === $k ? 'selected' : '' ?>><?= $v ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Asset tag</label>
                        <input type="text" name="asset_tag" class="form-control" value="<?= clean($item['asset_tag'] ?? '') ?>">
                    </div>
                    <div class="row">
                        <div class="col-6 mb-3">
                            <label class="form-label">Proizvođač</label>
                            <input type="text" name="manufacturer" class="form-control" value="<?= clean($item['manufacturer'] ?? '') ?>" placeholder="Cisco, HP, Dell...">
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label">Model</label>
                            <input type="text" name="model" class="form-control" value="<?= clean($item['model'] ?? '') ?>">
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Serijski broj</label>
                        <input type="text" name="serial_number" class="form-control" value="<?= clean($item['serial_number'] ?? '') ?>">
                    </div>
                    <div class="row">
                        <div class="col-6 mb-3">
                            <label class="form-label">Lokacija</label>
                            <input type="text" name="location" class="form-control" value="<?= clean($item['location'] ?? '') ?>" placeholder="Server soba, Rack 1...">
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label">Pozicija u racku</label>
                            <input type="text" name="rack_position" class="form-control" value="<?= clean($item['rack_position'] ?? '') ?>" placeholder="U1-U4">
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select">
                            <option value="active" <?= ($item['status'] ?? '') === 'active' ? 'selected' : '' ?>>Active</option>
                            <option value="maintenance" <?= ($item['status'] ?? '') === 'maintenance' ? 'selected' : '' ?>>Maintenance</option>
                            <option value="storage" <?= ($item['status'] ?? '') === 'storage' ? 'selected' : '' ?>>Storage</option>
                            <option value="retired" <?= ($item['status'] ?? '') === 'retired' ? 'selected' : '' ?>>Retired</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-6">
                    <h6 class="text-muted mb-3">Mrežni podaci</h6>
                    <div class="row">
                        <div class="col-6 mb-3">
                            <label class="form-label">IP adresa</label>
                            <input type="text" name="ip_address" class="form-control" value="<?= clean($item['ip_address'] ?? '') ?>">
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label">MAC adresa</label>
                            <input type="text" name="mac_address" class="form-control" value="<?= clean($item['mac_address'] ?? '') ?>">
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Broj portova</label>
                        <input type="number" name="ports_count" class="form-control" value="<?= (int)($item['ports_count'] ?? 0) ?>" min="0">
                    </div>
                    <h6 class="text-muted mb-3 mt-4">Jamstvo</h6>
                    <div class="row">
                        <div class="col-6 mb-3">
                            <label class="form-label">Datum kupnje</label>
                            <input type="date" name="purchase_date" class="form-control" value="<?= $item['purchase_date'] ?? '' ?>">
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label">Jamstvo do</label>
                            <input type="date" name="warranty_until" class="form-control" value="<?= $item['warranty_until'] ?? '' ?>">
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Napomene</label>
                        <textarea name="notes" class="form-control" rows="4"><?= clean($item['notes'] ?? '') ?></textarea>
                    </div>
                </div>
            </div>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary"><i class="bi bi-check-lg me-1"></i><?= $isEdit ? 'Spremi' : 'Dodaj' ?></button>
                <a href="index.php" class="btn btn-outline-secondary">Odustani</a>
            </div>
        </form>
    </div>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
