<?php
$pageTitle = 'Licencije - IT Inventory';
$currentPage = 'licenses';

require_once __DIR__ . '/../../includes/header.php';
requireLogin();

$db = getDB();
$search = $_GET['search'] ?? '';

$where = [];
$params = [];

if ($search) {
    $where[] = "(software_name LIKE ? OR vendor LIKE ? OR license_key LIKE ?)";
    $s = "%{$search}%";
    $params = array_merge($params, [$s, $s, $s]);
}

$whereClause = $where ? 'WHERE ' . implode(' AND ', $where) : '';
$stmt = $db->prepare("SELECT * FROM licenses {$whereClause} ORDER BY software_name");
$stmt->execute($params);
$licenses = $stmt->fetchAll();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4><i class="bi bi-key me-2"></i>Softverske licencije</h4>
    <a href="add.php" class="btn btn-primary"><i class="bi bi-plus-lg me-1"></i>Nova licencija</a>
</div>

<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-10">
                <div class="search-box">
                    <i class="bi bi-search"></i>
                    <input type="text" name="search" class="form-control" placeholder="Pretraži po softveru, vendoru ili ključu..." value="<?= clean($search) ?>">
                </div>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-outline-secondary w-100">Pretraži</button>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>Softver</th>
                    <th>Tip</th>
                    <th>Vendor</th>
                    <th class="text-center">Količina</th>
                    <th>Ističe</th>
                    <th>Status</th>
                    <th class="text-end">Akcije</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($licenses)): ?>
                <tr><td colspan="7" class="text-center text-muted py-4"><i class="bi bi-inbox display-6 d-block mb-2"></i>Nema licencija</td></tr>
                <?php else: ?>
                <?php foreach ($licenses as $l): ?>
                <tr>
                    <td>
                        <a href="view.php?id=<?= $l['id'] ?>" class="fw-bold text-decoration-none"><?= clean($l['software_name']) ?></a>
                        <?php if ($l['license_key']): ?><br><small class="text-muted"><code><?= substr(clean($l['license_key']), 0, 20) ?>...</code></small><?php endif; ?>
                    </td>
                    <td><span class="badge bg-secondary"><?= ucfirst($l['license_type']) ?></span></td>
                    <td><?= clean($l['vendor']) ?: '-' ?></td>
                    <td class="text-center">
                        <span class="badge bg-primary"><?= $l['used_quantity'] ?> / <?= $l['quantity'] ?></span>
                    </td>
                    <td><?= $l['expiry_date'] ? formatDate($l['expiry_date']) : '-' ?></td>
                    <td><?= licenseStatus($l['expiry_date']) ?></td>
                    <td class="text-end">
                        <a href="view.php?id=<?= $l['id'] ?>" class="btn btn-sm btn-outline-primary"><i class="bi bi-eye"></i></a>
                        <a href="edit.php?id=<?= $l['id'] ?>" class="btn btn-sm btn-outline-secondary"><i class="bi bi-pencil"></i></a>
                        <a href="delete.php?id=<?= $l['id'] ?>" class="btn btn-sm btn-outline-danger" data-confirm="Obrisati licenciju?"><i class="bi bi-trash"></i></a>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
