<?php
require_once __DIR__ . '/../../includes/header.php';
requireLogin();
$db = getDB();
$stmt = $db->prepare("SELECT * FROM licenses WHERE id = ?");
$stmt->execute([$_GET['id'] ?? 0]);
$license = $stmt->fetch();
if (!$license) { setFlash('error', 'Licencija nije pronađena.'); header('Location: index.php'); exit; }
$pageTitle = $license['software_name'] . ' - IT Inventory';
$currentPage = 'licenses';
?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4><i class="bi bi-key me-2"></i><?= clean($license['software_name']) ?> <?= licenseStatus($license['expiry_date']) ?></h4>
        <p class="text-muted mb-0"><span class="badge bg-secondary"><?= ucfirst($license['license_type']) ?></span> · <?= clean($license['vendor']) ?></p>
    </div>
    <div>
        <a href="edit.php?id=<?= $license['id'] ?>" class="btn btn-outline-primary"><i class="bi bi-pencil me-1"></i>Uredi</a>
        <a href="index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-1"></i>Natrag</a>
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-header bg-white"><h6 class="mb-0">Informacije</h6></div>
            <div class="card-body">
                <table class="table table-sm">
                    <tr><th class="text-muted" style="width:35%">Licencni ključ</th><td><code style="word-break:break-all"><?= clean($license['license_key']) ?: '-' ?></code></td></tr>
                    <tr><th class="text-muted">Količina</th><td><?= $license['used_quantity'] ?> / <?= $license['quantity'] ?> iskorišteno</td></tr>
                    <tr><th class="text-muted">Dodijeljeno</th><td><?= clean($license['assigned_to']) ?: '-' ?></td></tr>
                    <tr><th class="text-muted">Cijena</th><td><?= $license['cost'] ? number_format($license['cost'], 2) . ' EUR' : '-' ?></td></tr>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card mb-4">
            <div class="card-header bg-white"><h6 class="mb-0">Datumi</h6></div>
            <div class="card-body">
                <table class="table table-sm">
                    <tr><th class="text-muted" style="width:35%">Datum kupnje</th><td><?= formatDate($license['purchase_date']) ?></td></tr>
                    <tr><th class="text-muted">Datum isteka</th><td><?= formatDate($license['expiry_date']) ?></td></tr>
                    <tr><th class="text-muted">Kreirano</th><td><?= formatDateTime($license['created_at']) ?></td></tr>
                    <tr><th class="text-muted">Ažurirano</th><td><?= formatDateTime($license['updated_at']) ?></td></tr>
                </table>
            </div>
        </div>
    </div>
</div>
<?php if ($license['notes']): ?><div class="card"><div class="card-header bg-white"><h6 class="mb-0">Napomene</h6></div><div class="card-body"><?= nl2br(clean($license['notes'])) ?></div></div><?php endif; ?>
<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
