<?php
$pageTitle = 'PC računala - IT Inventory';
$currentPage = 'pcs';

require_once __DIR__ . '/../../includes/header.php';
requireLogin();

$db = getDB();
$search = $_GET['search'] ?? '';
$status = $_GET['status'] ?? '';

$where = [];
$params = [];

if ($search) {
    $where[] = "(p.name LIKE ? OR p.serial_number LIKE ? OR p.model LIKE ? OR u.full_name LIKE ?)";
    $s = "%{$search}%";
    $params = array_merge($params, [$s, $s, $s, $s]);
}
if ($status) { $where[] = "p.status = ?"; $params[] = $status; }

$whereClause = $where ? 'WHERE ' . implode(' AND ', $where) : '';
$stmt = $db->prepare("
    SELECT p.*, u.full_name as user_name 
    FROM pcs p 
    LEFT JOIN users u ON p.user_id = u.id 
    {$whereClause} 
    ORDER BY p.name
");
$stmt->execute($params);
$pcs = $stmt->fetchAll();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4><i class="bi bi-pc-display-horizontal me-2"></i>PC računala</h4>
    <a href="add.php" class="btn btn-primary"><i class="bi bi-plus-lg me-1"></i>Novi PC</a>
</div>

<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-6">
                <div class="search-box">
                    <i class="bi bi-search"></i>
                    <input type="text" name="search" class="form-control" placeholder="Pretraži..." value="<?= clean($search) ?>">
                </div>
            </div>
            <div class="col-md-4">
                <select name="status" class="form-select">
                    <option value="">Svi statusi</option>
                    <option value="active" <?= $status === 'active' ? 'selected' : '' ?>>Active</option>
                    <option value="maintenance" <?= $status === 'maintenance' ? 'selected' : '' ?>>Maintenance</option>
                    <option value="storage" <?= $status === 'storage' ? 'selected' : '' ?>>Storage</option>
                    <option value="retired" <?= $status === 'retired' ? 'selected' : '' ?>>Retired</option>
                </select>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-outline-secondary w-100">Filtriraj</button>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>Naziv</th>
                    <th>Model</th>
                    <th>Serijski br.</th>
                    <th>Spec</th>
                    <th>Korisnik</th>
                    <th>Status</th>
                    <th class="text-end">Akcije</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($pcs)): ?>
                <tr><td colspan="7" class="text-center text-muted py-4"><i class="bi bi-inbox display-6 d-block mb-2"></i>Nema PC računala</td></tr>
                <?php else: ?>
                <?php foreach ($pcs as $p): ?>
                <tr>
                    <td>
                        <a href="view.php?id=<?= $p['id'] ?>" class="fw-bold text-decoration-none"><?= clean($p['name']) ?></a>
                        <?php if ($p['asset_tag']): ?><br><small class="text-muted"><?= clean($p['asset_tag']) ?></small><?php endif; ?>
                    </td>
                    <td><?= clean($p['manufacturer']) ?> <?= clean($p['model']) ?></td>
                    <td><code><?= clean($p['serial_number']) ?: '-' ?></code></td>
                    <td><small><?= clean($p['cpu']) ?><br><?= $p['ram_gb'] ?>GB / <?= $p['storage_gb'] ?>GB <?= $p['storage_type'] ?></small></td>
                    <td>
                        <?php if ($p['user_id']): ?>
                        <a href="<?= APP_URL ?>/modules/users/view.php?id=<?= $p['user_id'] ?>"><?= clean($p['user_name']) ?></a>
                        <?php else: ?>
                        <span class="text-muted">-</span>
                        <?php endif; ?>
                    </td>
                    <td><?= statusBadge($p['status']) ?></td>
                    <td class="text-end">
                        <a href="view.php?id=<?= $p['id'] ?>" class="btn btn-sm btn-outline-primary"><i class="bi bi-eye"></i></a>
                        <a href="edit.php?id=<?= $p['id'] ?>" class="btn btn-sm btn-outline-secondary"><i class="bi bi-pencil"></i></a>
                        <a href="delete.php?id=<?= $p['id'] ?>" class="btn btn-sm btn-outline-danger" data-confirm="Obrisati PC?"><i class="bi bi-trash"></i></a>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
