<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/functions.php';
require_once __DIR__ . '/../../includes/auth.php';

if (session_status() === PHP_SESSION_NONE) { session_name(SESSION_NAME); session_start(); }
if (!isLoggedIn()) { header('Location: ' . APP_URL . '/login.php'); exit; }

$isEdit = isset($_GET['id']);
$db = getDB();
$item = null;
$errors = [];
$users = $db->query("SELECT id, full_name, department FROM users WHERE status = 'active' ORDER BY full_name")->fetchAll();

if ($isEdit) {
    $stmt = $db->prepare("SELECT * FROM phones WHERE id = ?");
    $stmt->execute([$_GET['id']]);
    $item = $stmt->fetch();
    if (!$item) { setFlash('error', 'Mobitel nije pronađen.'); header('Location: index.php'); exit; }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verifyCSRF($_POST['csrf_token'] ?? '')) { $errors[] = 'Nevažeći CSRF token.'; }
    $data = [
        'name' => trim($_POST['name'] ?? ''), 'asset_tag' => trim($_POST['asset_tag'] ?? ''),
        'manufacturer' => trim($_POST['manufacturer'] ?? ''), 'model' => trim($_POST['model'] ?? ''),
        'serial_number' => trim($_POST['serial_number'] ?? ''), 'imei' => trim($_POST['imei'] ?? ''),
        'imei2' => trim($_POST['imei2'] ?? ''), 'phone_number' => trim($_POST['phone_number'] ?? ''),
        'sim_operator' => trim($_POST['sim_operator'] ?? ''), 'storage_gb' => (int)($_POST['storage_gb'] ?? 0),
        'os' => trim($_POST['os'] ?? ''), 'os_version' => trim($_POST['os_version'] ?? ''),
        'user_id' => !empty($_POST['user_id']) ? (int)$_POST['user_id'] : null,
        'assigned_to' => '', 'department' => trim($_POST['department'] ?? ''),
        'purchase_date' => $_POST['purchase_date'] ?: null, 'warranty_until' => $_POST['warranty_until'] ?: null,
        'status' => $_POST['status'] ?? 'active', 'notes' => trim($_POST['notes'] ?? '')
    ];
    if (empty($data['name'])) $errors[] = 'Naziv je obavezan.';
    if (empty($errors)) {
        try {
            if ($isEdit) {
                $stmt = $db->prepare("UPDATE phones SET name=?, asset_tag=?, manufacturer=?, model=?, serial_number=?, imei=?, imei2=?, phone_number=?, sim_operator=?, storage_gb=?, os=?, os_version=?, user_id=?, assigned_to=?, department=?, purchase_date=?, warranty_until=?, status=?, notes=? WHERE id=?");
                $stmt->execute([$data['name'], $data['asset_tag'], $data['manufacturer'], $data['model'], $data['serial_number'], $data['imei'], $data['imei2'], $data['phone_number'], $data['sim_operator'], $data['storage_gb'], $data['os'], $data['os_version'], $data['user_id'], $data['assigned_to'], $data['department'], $data['purchase_date'], $data['warranty_until'], $data['status'], $data['notes'], $_GET['id']]);
                logChange('update', 'phone', $_GET['id'], $data['name'], $item, $data);
                setFlash('success', 'Mobitel je ažuriran.');
            } else {
                $stmt = $db->prepare("INSERT INTO phones (name, asset_tag, manufacturer, model, serial_number, imei, imei2, phone_number, sim_operator, storage_gb, os, os_version, user_id, assigned_to, department, purchase_date, warranty_until, status, notes) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                $stmt->execute([$data['name'], $data['asset_tag'], $data['manufacturer'], $data['model'], $data['serial_number'], $data['imei'], $data['imei2'], $data['phone_number'], $data['sim_operator'], $data['storage_gb'], $data['os'], $data['os_version'], $data['user_id'], $data['assigned_to'], $data['department'], $data['purchase_date'], $data['warranty_until'], $data['status'], $data['notes']]);
                logChange('create', 'phone', $db->lastInsertId(), $data['name'], null, $data);
                setFlash('success', 'Mobitel je dodan.');
            }
            header('Location: index.php'); exit;
        } catch (PDOException $e) { $errors[] = 'Greška: ' . $e->getMessage(); }
    }
    $item = $data;
}
$pageTitle = ($isEdit ? 'Uredi' : 'Novi') . ' mobitel - IT Inventory';
$currentPage = 'phones';
require_once __DIR__ . '/../../includes/header.php';
?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h4><i class="bi bi-phone me-2"></i><?= $isEdit ? 'Uredi: ' . clean($item['name']) : 'Novi mobitel' ?></h4>
    <a href="index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-1"></i>Natrag</a>
</div>
<?php if ($errors): ?><div class="alert alert-danger"><ul class="mb-0"><?php foreach ($errors as $e): ?><li><?= clean($e) ?></li><?php endforeach; ?></ul></div><?php endif; ?>
<div class="card"><div class="card-body">
<form method="POST"><input type="hidden" name="csrf_token" value="<?= generateCSRF() ?>">
<div class="row">
<div class="col-md-6">
    <h6 class="text-muted mb-3">Osnovni podaci</h6>
    <div class="row"><div class="col-8 mb-3"><label class="form-label required">Naziv</label><input type="text" name="name" class="form-control" value="<?= clean($item['name'] ?? '') ?>" required></div><div class="col-4 mb-3"><label class="form-label">Asset tag</label><input type="text" name="asset_tag" class="form-control" value="<?= clean($item['asset_tag'] ?? '') ?>"></div></div>
    <div class="row"><div class="col-6 mb-3"><label class="form-label">Proizvođač</label><input type="text" name="manufacturer" class="form-control" value="<?= clean($item['manufacturer'] ?? '') ?>"></div><div class="col-6 mb-3"><label class="form-label">Model</label><input type="text" name="model" class="form-control" value="<?= clean($item['model'] ?? '') ?>"></div></div>
    <div class="mb-3"><label class="form-label">Serijski broj</label><input type="text" name="serial_number" class="form-control" value="<?= clean($item['serial_number'] ?? '') ?>"></div>
    <div class="row"><div class="col-6 mb-3"><label class="form-label">IMEI</label><input type="text" name="imei" class="form-control" value="<?= clean($item['imei'] ?? '') ?>"></div><div class="col-6 mb-3"><label class="form-label">IMEI 2</label><input type="text" name="imei2" class="form-control" value="<?= clean($item['imei2'] ?? '') ?>"></div></div>
    <div class="mb-3"><label class="form-label">Korisnik</label><select name="user_id" class="form-select"><option value="">-- Nije dodijeljen --</option><?php foreach ($users as $u): ?><option value="<?= $u['id'] ?>" <?= ($item['user_id'] ?? '') == $u['id'] ? 'selected' : '' ?>><?= clean($u['full_name']) ?></option><?php endforeach; ?></select></div>
    <div class="mb-3"><label class="form-label">Odjel</label><input type="text" name="department" class="form-control" value="<?= clean($item['department'] ?? '') ?>"></div>
    <div class="mb-3"><label class="form-label">Status</label><select name="status" class="form-select"><option value="active" <?= ($item['status'] ?? '') === 'active' ? 'selected' : '' ?>>Active</option><option value="maintenance" <?= ($item['status'] ?? '') === 'maintenance' ? 'selected' : '' ?>>Maintenance</option><option value="storage" <?= ($item['status'] ?? '') === 'storage' ? 'selected' : '' ?>>Storage</option><option value="retired" <?= ($item['status'] ?? '') === 'retired' ? 'selected' : '' ?>>Retired</option></select></div>
</div>
<div class="col-md-6">
    <h6 class="text-muted mb-3">SIM & Specifikacije</h6>
    <div class="row"><div class="col-6 mb-3"><label class="form-label">Telefonski broj</label><input type="text" name="phone_number" class="form-control" value="<?= clean($item['phone_number'] ?? '') ?>"></div><div class="col-6 mb-3"><label class="form-label">Operator</label><input type="text" name="sim_operator" class="form-control" value="<?= clean($item['sim_operator'] ?? '') ?>"></div></div>
    <div class="mb-3"><label class="form-label">Storage (GB)</label><input type="number" name="storage_gb" class="form-control" value="<?= (int)($item['storage_gb'] ?? 128) ?>"></div>
    <div class="row"><div class="col-6 mb-3"><label class="form-label">OS</label><input type="text" name="os" class="form-control" value="<?= clean($item['os'] ?? '') ?>"></div><div class="col-6 mb-3"><label class="form-label">OS verzija</label><input type="text" name="os_version" class="form-control" value="<?= clean($item['os_version'] ?? '') ?>"></div></div>
    <div class="row"><div class="col-6 mb-3"><label class="form-label">Datum kupnje</label><input type="date" name="purchase_date" class="form-control" value="<?= $item['purchase_date'] ?? '' ?>"></div><div class="col-6 mb-3"><label class="form-label">Jamstvo do</label><input type="date" name="warranty_until" class="form-control" value="<?= $item['warranty_until'] ?? '' ?>"></div></div>
    <div class="mb-3"><label class="form-label">Napomene</label><textarea name="notes" class="form-control" rows="3"><?= clean($item['notes'] ?? '') ?></textarea></div>
</div></div>
<div class="d-flex gap-2"><button type="submit" class="btn btn-primary"><i class="bi bi-check-lg me-1"></i><?= $isEdit ? 'Spremi' : 'Dodaj' ?></button><a href="index.php" class="btn btn-outline-secondary">Odustani</a></div>
</form></div></div>
<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
