<?php
$isEdit = isset($_GET['id']);
$pageTitle = ($isEdit ? 'Uredi' : 'Novi') . ' printer - IT Inventory';
$currentPage = 'printers';

require_once __DIR__ . '/../../includes/header.php';
requireLogin();

$db = getDB();
$printer = null;
$errors = [];

if ($isEdit) {
    $stmt = $db->prepare("SELECT * FROM printers WHERE id = ?");
    $stmt->execute([$_GET['id']]);
    $printer = $stmt->fetch();
    if (!$printer) { setFlash('error', 'Printer nije pronađen.'); header('Location: index.php'); exit; }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verifyCSRF($_POST['csrf_token'] ?? '')) { $errors[] = 'Nevažeći CSRF token.'; }
    
    $data = [
        'name' => trim($_POST['name'] ?? ''),
        'ip_address' => trim($_POST['ip_address'] ?? ''),
        'mac_address' => trim($_POST['mac_address'] ?? ''),
        'manufacturer' => trim($_POST['manufacturer'] ?? ''),
        'model' => trim($_POST['model'] ?? ''),
        'serial_number' => trim($_POST['serial_number'] ?? ''),
        'location' => trim($_POST['location'] ?? ''),
        'type' => $_POST['type'] ?? 'laser',
        'color' => isset($_POST['color']) ? 1 : 0,
        'duplex' => isset($_POST['duplex']) ? 1 : 0,
        'network_name' => trim($_POST['network_name'] ?? ''),
        'driver_info' => trim($_POST['driver_info'] ?? ''),
        'status' => $_POST['status'] ?? 'active',
        'notes' => trim($_POST['notes'] ?? '')
    ];
    
    if (empty($data['name'])) $errors[] = 'Naziv je obavezan.';
    if (empty($data['ip_address'])) $errors[] = 'IP adresa je obavezna.';
    if (!filter_var($data['ip_address'], FILTER_VALIDATE_IP)) $errors[] = 'IP adresa nije ispravna.';
    
    if (empty($errors)) {
        try {
            if ($isEdit) {
                $stmt = $db->prepare("UPDATE printers SET name=?, ip_address=?, mac_address=?, manufacturer=?, model=?, serial_number=?, location=?, type=?, color=?, duplex=?, network_name=?, driver_info=?, status=?, notes=? WHERE id=?");
                $stmt->execute([$data['name'], $data['ip_address'], $data['mac_address'], $data['manufacturer'], $data['model'], $data['serial_number'], $data['location'], $data['type'], $data['color'], $data['duplex'], $data['network_name'], $data['driver_info'], $data['status'], $data['notes'], $_GET['id']]);
                logChange('update', 'printer', $_GET['id'], $data['name'], $printer, $data);
                setFlash('success', 'Printer je ažuriran.');
            } else {
                $stmt = $db->prepare("INSERT INTO printers (name, ip_address, mac_address, manufacturer, model, serial_number, location, type, color, duplex, network_name, driver_info, status, notes) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                $stmt->execute([$data['name'], $data['ip_address'], $data['mac_address'], $data['manufacturer'], $data['model'], $data['serial_number'], $data['location'], $data['type'], $data['color'], $data['duplex'], $data['network_name'], $data['driver_info'], $data['status'], $data['notes']]);
                logChange('create', 'printer', $db->lastInsertId(), $data['name'], null, $data);
                setFlash('success', 'Printer je dodan.');
            }
            header('Location: index.php'); exit;
        } catch (PDOException $e) { $errors[] = 'Greška: ' . $e->getMessage(); }
    }
    $printer = $data;
}
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4><i class="bi bi-printer me-2"></i><?= $isEdit ? 'Uredi: ' . clean($printer['name']) : 'Novi printer' ?></h4>
    <a href="index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-1"></i>Natrag</a>
</div>

<?php if ($errors): ?><div class="alert alert-danger"><ul class="mb-0"><?php foreach ($errors as $e): ?><li><?= clean($e) ?></li><?php endforeach; ?></ul></div><?php endif; ?>

<div class="card">
    <div class="card-body">
        <form method="POST">
            <input type="hidden" name="csrf_token" value="<?= generateCSRF() ?>">
            <div class="row">
                <div class="col-md-6">
                    <h6 class="text-muted mb-3">Osnovni podaci</h6>
                    <div class="mb-3">
                        <label class="form-label required">Naziv</label>
                        <input type="text" name="name" class="form-control" value="<?= clean($printer['name'] ?? '') ?>" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label required">IP adresa</label>
                        <input type="text" name="ip_address" class="form-control" value="<?= clean($printer['ip_address'] ?? '') ?>" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">MAC adresa</label>
                        <input type="text" name="mac_address" class="form-control" value="<?= clean($printer['mac_address'] ?? '') ?>" placeholder="AA:BB:CC:DD:EE:FF">
                    </div>
                    <div class="row">
                        <div class="col-6 mb-3">
                            <label class="form-label">Proizvođač</label>
                            <input type="text" name="manufacturer" class="form-control" value="<?= clean($printer['manufacturer'] ?? '') ?>" placeholder="HP, Canon, Epson...">
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label">Model</label>
                            <input type="text" name="model" class="form-control" value="<?= clean($printer['model'] ?? '') ?>">
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Serijski broj</label>
                        <input type="text" name="serial_number" class="form-control" value="<?= clean($printer['serial_number'] ?? '') ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Lokacija</label>
                        <input type="text" name="location" class="form-control" value="<?= clean($printer['location'] ?? '') ?>" placeholder="Ured 101, Hodnik 2. kat">
                    </div>
                </div>
                <div class="col-md-6">
                    <h6 class="text-muted mb-3">Specifikacije</h6>
                    <div class="mb-3">
                        <label class="form-label">Tip</label>
                        <select name="type" class="form-select">
                            <option value="laser" <?= ($printer['type'] ?? '') === 'laser' ? 'selected' : '' ?>>Laser</option>
                            <option value="inkjet" <?= ($printer['type'] ?? '') === 'inkjet' ? 'selected' : '' ?>>Inkjet</option>
                            <option value="multifunction" <?= ($printer['type'] ?? '') === 'multifunction' ? 'selected' : '' ?>>Multifunction</option>
                            <option value="plotter" <?= ($printer['type'] ?? '') === 'plotter' ? 'selected' : '' ?>>Plotter</option>
                            <option value="other" <?= ($printer['type'] ?? '') === 'other' ? 'selected' : '' ?>>Ostalo</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <div class="form-check">
                            <input type="checkbox" name="color" class="form-check-input" id="color" <?= ($printer['color'] ?? 0) ? 'checked' : '' ?>>
                            <label class="form-check-label" for="color">Color printer</label>
                        </div>
                        <div class="form-check">
                            <input type="checkbox" name="duplex" class="form-check-input" id="duplex" <?= ($printer['duplex'] ?? 0) ? 'checked' : '' ?>>
                            <label class="form-check-label" for="duplex">Duplex (obostrani ispis)</label>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Mrežno ime (share name)</label>
                        <input type="text" name="network_name" class="form-control" value="<?= clean($printer['network_name'] ?? '') ?>" placeholder="\\server\printer">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Driver info</label>
                        <input type="text" name="driver_info" class="form-control" value="<?= clean($printer['driver_info'] ?? '') ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select">
                            <option value="active" <?= ($printer['status'] ?? '') === 'active' ? 'selected' : '' ?>>Active</option>
                            <option value="maintenance" <?= ($printer['status'] ?? '') === 'maintenance' ? 'selected' : '' ?>>Maintenance</option>
                            <option value="offline" <?= ($printer['status'] ?? '') === 'offline' ? 'selected' : '' ?>>Offline</option>
                            <option value="retired" <?= ($printer['status'] ?? '') === 'retired' ? 'selected' : '' ?>>Retired</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Napomene</label>
                        <textarea name="notes" class="form-control" rows="3"><?= clean($printer['notes'] ?? '') ?></textarea>
                    </div>
                </div>
            </div>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary"><i class="bi bi-check-lg me-1"></i><?= $isEdit ? 'Spremi' : 'Dodaj' ?></button>
                <a href="index.php" class="btn btn-outline-secondary">Odustani</a>
            </div>
        </form>
    </div>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
