<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/functions.php';
require_once __DIR__ . '/../../includes/auth.php';

if (session_status() === PHP_SESSION_NONE) {
    session_name(SESSION_NAME);
    session_start();
}

if (!isLoggedIn()) {
    header('Location: ' . APP_URL . '/login.php');
    exit;
}

if (!isAdmin()) {
    setFlash('error', 'Nemate ovlasti.');
    header('Location: index.php');
    exit;
}

$db = getDB();
$stmt = $db->prepare("SELECT * FROM servers WHERE id = ?");
$stmt->execute([$_GET['id'] ?? 0]);
$item = $stmt->fetch();

if (!$item) {
    setFlash('error', 'Server nije pronađen.');
    header('Location: index.php');
    exit;
}

$stmt = $db->prepare("DELETE FROM servers WHERE id = ?");
$stmt->execute([$item['id']]);
logChange('delete', 'server', $item['id'], $item['name'], $item, null);

setFlash('success', 'Server je obrisan.');
header('Location: index.php');
exit;