<?php
/**
 * IT Inventory - Servers List
 */
$pageTitle = 'Serveri - IT Inventory';
$currentPage = 'servers';

require_once __DIR__ . '/../../includes/header.php';
requireLogin();

$db = getDB();

// Pretraga i filtriranje
$search = $_GET['search'] ?? '';
$status = $_GET['status'] ?? '';

$where = [];
$params = [];

if ($search) {
    $where[] = "(name LIKE ? OR ip_address LIKE ? OR hostname LIKE ? OR location LIKE ?)";
    $searchTerm = "%{$search}%";
    $params = array_merge($params, [$searchTerm, $searchTerm, $searchTerm, $searchTerm]);
}

if ($status) {
    $where[] = "status = ?";
    $params[] = $status;
}

$whereClause = $where ? 'WHERE ' . implode(' AND ', $where) : '';

// Dohvat servera s brojem VM-ova
$sql = "
    SELECT s.*, COUNT(v.id) as vm_count, SUM(v.status = 'running') as vm_running
    FROM servers s
    LEFT JOIN virtual_machines v ON s.id = v.server_id
    {$whereClause}
    GROUP BY s.id
    ORDER BY s.name
";

$stmt = $db->prepare($sql);
$stmt->execute($params);
$servers = $stmt->fetchAll();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4><i class="bi bi-server me-2"></i>Serveri (Proxmox)</h4>
    <a href="add.php" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i>Novi server
    </a>
</div>

<!-- Filters -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-6">
                <div class="search-box">
                    <i class="bi bi-search"></i>
                    <input type="text" name="search" class="form-control" placeholder="Pretraži..." value="<?= clean($search) ?>">
                </div>
            </div>
            <div class="col-md-4">
                <select name="status" class="form-select">
                    <option value="">Svi statusi</option>
                    <option value="active" <?= $status === 'active' ? 'selected' : '' ?>>Active</option>
                    <option value="maintenance" <?= $status === 'maintenance' ? 'selected' : '' ?>>Maintenance</option>
                    <option value="offline" <?= $status === 'offline' ? 'selected' : '' ?>>Offline</option>
                </select>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-outline-secondary w-100">Filtriraj</button>
            </div>
        </form>
    </div>
</div>

<!-- Server List -->
<div class="card">
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>Naziv</th>
                    <th>IP adresa</th>
                    <th>Lokacija</th>
                    <th>Proxmox</th>
                    <th class="text-center">VM-ovi</th>
                    <th>Status</th>
                    <th class="text-end">Akcije</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($servers)): ?>
                <tr>
                    <td colspan="7" class="text-center text-muted py-4">
                        <i class="bi bi-inbox display-6 d-block mb-2"></i>
                        Nema servera
                    </td>
                </tr>
                <?php else: ?>
                <?php foreach ($servers as $server): ?>
                <tr>
                    <td>
                        <a href="view.php?id=<?= $server['id'] ?>" class="fw-bold text-decoration-none">
                            <?= clean($server['name']) ?>
                        </a>
                        <?php if ($server['hostname']): ?>
                        <br><small class="text-muted"><?= clean($server['hostname']) ?></small>
                        <?php endif; ?>
                    </td>
                    <td>
                        <code><?= clean($server['ip_address']) ?></code>
                        <button class="btn btn-sm btn-link p-0 ms-1" data-copy="<?= clean($server['ip_address']) ?>" title="Kopiraj">
                            <i class="bi bi-clipboard"></i>
                        </button>
                    </td>
                    <td><?= clean($server['location']) ?: '-' ?></td>
                    <td><?= clean($server['proxmox_version']) ?: '-' ?></td>
                    <td class="text-center">
                        <span class="badge bg-primary"><?= $server['vm_count'] ?></span>
                        <?php if ($server['vm_running']): ?>
                        <span class="badge bg-success"><?= $server['vm_running'] ?> running</span>
                        <?php endif; ?>
                    </td>
                    <td><?= statusBadge($server['status']) ?></td>
                    <td class="text-end">
                        <a href="view.php?id=<?= $server['id'] ?>" class="btn btn-sm btn-outline-primary" title="Detalji">
                            <i class="bi bi-eye"></i>
                        </a>
                        <a href="edit.php?id=<?= $server['id'] ?>" class="btn btn-sm btn-outline-secondary" title="Uredi">
                            <i class="bi bi-pencil"></i>
                        </a>
                        <a href="delete.php?id=<?= $server['id'] ?>" class="btn btn-sm btn-outline-danger" title="Obriši" data-confirm="Jeste li sigurni da želite obrisati ovaj server i sve njegove VM-ove?">
                            <i class="bi bi-trash"></i>
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
