<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/functions.php';
require_once __DIR__ . '/../../includes/auth.php';

if (session_status() === PHP_SESSION_NONE) {
    session_name(SESSION_NAME);
    session_start();
}

if (!isLoggedIn()) {
    header('Location: ' . APP_URL . '/login.php');
    exit;
}

$db = getDB();
$stmt = $db->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$_GET['id'] ?? 0]);
$user = $stmt->fetch();

if (!$user) {
    die('Korisnik nije pronađen.');
}

// Dohvati uređaje
$pcs = $db->prepare("SELECT * FROM pcs WHERE user_id = ?"); $pcs->execute([$user['id']]); $pcs = $pcs->fetchAll();
$laptops = $db->prepare("SELECT * FROM laptops WHERE user_id = ?"); $laptops->execute([$user['id']]); $laptops = $laptops->fetchAll();
$phones = $db->prepare("SELECT * FROM phones WHERE user_id = ?"); $phones->execute([$user['id']]); $phones = $phones->fetchAll();
?>
<!DOCTYPE html>
<html lang="hr">
<head>
    <meta charset="UTF-8">
    <title>Pristupni podaci - <?= htmlspecialchars($user['full_name']) ?></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: Arial, sans-serif; font-size: 12pt; line-height: 1.5; padding: 20mm; }
        .header { text-align: center; margin-bottom: 30px; padding-bottom: 15px; border-bottom: 2px solid #333; }
        .header h1 { font-size: 18pt; margin-bottom: 5px; }
        .header p { color: #666; }
        .section { margin-bottom: 25px; }
        .section h2 { font-size: 14pt; background: #f5f5f5; padding: 8px 12px; margin-bottom: 15px; border-left: 4px solid #333; }
        .info-table { width: 100%; border-collapse: collapse; }
        .info-table th, .info-table td { padding: 8px 12px; text-align: left; border-bottom: 1px solid #ddd; }
        .info-table th { width: 200px; color: #666; font-weight: normal; }
        .info-table td { font-weight: bold; }
        .credential-box { background: #fff3cd; border: 1px solid #ffc107; padding: 15px; margin: 10px 0; border-radius: 5px; }
        .credential-box strong { display: block; margin-bottom: 5px; }
        .credential-box code { font-size: 14pt; background: #fff; padding: 5px 10px; border-radius: 3px; }
        .devices-list { list-style: none; }
        .devices-list li { padding: 8px 0; border-bottom: 1px dotted #ddd; }
        .footer { margin-top: 40px; padding-top: 20px; border-top: 1px solid #ddd; font-size: 10pt; color: #666; }
        .signature-line { margin-top: 50px; display: flex; justify-content: space-between; }
        .signature-box { width: 45%; }
        .signature-box .line { border-bottom: 1px solid #333; height: 40px; margin-bottom: 5px; }
        .no-print { margin-bottom: 20px; padding: 15px; background: #e7f3ff; border-radius: 5px; }
        .no-print button { padding: 10px 20px; font-size: 14px; cursor: pointer; margin-right: 10px; }
        @media print {
            .no-print { display: none; }
            body { padding: 10mm; }
        }
    </style>
</head>
<body>
    <div class="no-print">
        <button onclick="window.print()">🖨️ Ispiši</button>
        <button onclick="window.close()">✕ Zatvori</button>
    </div>

    <div class="header">
        <h1>PRISTUPNI PODACI KORISNIKA</h1>
        <p>Povjerljiv dokument - čuvati na sigurnom mjestu</p>
    </div>

    <div class="section">
        <h2>Osobni podaci</h2>
        <table class="info-table">
            <tr><th>Ime i prezime:</th><td><?= htmlspecialchars($user['full_name']) ?></td></tr>
            <tr><th>Korisničko ime:</th><td><?= htmlspecialchars($user['username']) ?></td></tr>
            <tr><th>Email:</th><td><?= htmlspecialchars($user['email']) ?: '-' ?></td></tr>
            <tr><th>Odjel:</th><td><?= htmlspecialchars($user['department']) ?: '-' ?></td></tr>
            <tr><th>Pozicija:</th><td><?= htmlspecialchars($user['position']) ?: '-' ?></td></tr>
            <tr><th>Telefon:</th><td><?= htmlspecialchars($user['phone']) ?: '-' ?></td></tr>
        </table>
    </div>

    <?php if ($user['ad_enabled']): ?>
    <div class="section">
        <h2>Active Directory / Windows prijava</h2>
        <div class="credential-box">
            <strong>Korisničko ime:</strong>
            <code><?= htmlspecialchars($user['username']) ?></code>
        </div>
        <div class="credential-box">
            <strong>Lozinka:</strong>
            <code><?= htmlspecialchars($user['ad_password']) ?: '(nije postavljena)' ?></code>
        </div>
    </div>
    <?php endif; ?>

    <?php if ($user['zimbra_enabled']): ?>
    <div class="section">
        <h2>Zimbra Email</h2>
        <table class="info-table">
            <tr><th>Email adresa:</th><td><?= htmlspecialchars($user['email']) ?></td></tr>
            <tr><th>Kvota:</th><td><?= $user['zimbra_quota_gb'] ?> GB</td></tr>
        </table>
        <div class="credential-box">
            <strong>Lozinka:</strong>
            <code><?= htmlspecialchars($user['zimbra_password']) ?: '(nije postavljena)' ?></code>
        </div>
    </div>
    <?php endif; ?>

    <?php if ($user['nextcloud_enabled']): ?>
    <div class="section">
        <h2>Nextcloud</h2>
        <table class="info-table">
            <tr><th>Korisničko ime:</th><td><?= htmlspecialchars($user['username']) ?></td></tr>
            <tr><th>Kvota:</th><td><?= $user['nextcloud_quota_gb'] ?> GB</td></tr>
        </table>
        <div class="credential-box">
            <strong>Lozinka:</strong>
            <code><?= htmlspecialchars($user['nextcloud_password']) ?: '(nije postavljena)' ?></code>
        </div>
    </div>
    <?php endif; ?>

    <?php if ($pcs || $laptops || $phones): ?>
    <div class="section">
        <h2>Dodijeljena oprema</h2>
        <ul class="devices-list">
            <?php foreach ($pcs as $d): ?>
            <li><strong>PC:</strong> <?= htmlspecialchars($d['name']) ?> - <?= htmlspecialchars($d['manufacturer']) ?> <?= htmlspecialchars($d['model']) ?> <?= $d['serial_number'] ? '(S/N: ' . htmlspecialchars($d['serial_number']) . ')' : '' ?></li>
            <?php endforeach; ?>
            <?php foreach ($laptops as $d): ?>
            <li><strong>Laptop:</strong> <?= htmlspecialchars($d['name']) ?> - <?= htmlspecialchars($d['manufacturer']) ?> <?= htmlspecialchars($d['model']) ?> <?= $d['serial_number'] ? '(S/N: ' . htmlspecialchars($d['serial_number']) . ')' : '' ?></li>
            <?php endforeach; ?>
            <?php foreach ($phones as $d): ?>
            <li><strong>Mobitel:</strong> <?= htmlspecialchars($d['name']) ?> - <?= htmlspecialchars($d['manufacturer']) ?> <?= htmlspecialchars($d['model']) ?> <?= $d['phone_number'] ? '(Tel: ' . htmlspecialchars($d['phone_number']) . ')' : '' ?></li>
            <?php endforeach; ?>
        </ul>
    </div>
    <?php endif; ?>

    <div class="signature-line">
        <div class="signature-box">
            <div class="line"></div>
            <small>Potpis zaposlenika</small>
        </div>
        <div class="signature-box">
            <div class="line"></div>
            <small>Potpis IT odjela</small>
        </div>
    </div>

    <div class="footer">
        <p>Dokument generiran: <?= date('d.m.Y. H:i') ?></p>
        <p>⚠️ Ovaj dokument sadrži povjerljive podatke. Molimo čuvajte ga na sigurnom mjestu i ne dijelite s neovlaštenim osobama.</p>
    </div>
</body>
</html>
