<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/functions.php';
require_once __DIR__ . '/../../includes/auth.php';
if (session_status() === PHP_SESSION_NONE) { session_name(SESSION_NAME); session_start(); }
if (!isLoggedIn()) { header('Location: ' . APP_URL . '/login.php'); exit; }
if (!isAdmin()) { setFlash('error', 'Nemate ovlasti.'); header('Location: index.php'); exit; }
$db = getDB();
$stmt = $db->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$_GET['id'] ?? 0]);
$user = $stmt->fetch();
if (!$user) { setFlash('error', 'Korisnik nije pronađen.'); header('Location: index.php'); exit; }
$stmt = $db->prepare("DELETE FROM users WHERE id = ?");
$stmt->execute([$user['id']]);
logChange('delete', 'user', $user['id'], $user['full_name'], $user, null);
setFlash('success', 'Korisnik je obrisan.');
header('Location: index.php');
exit;
