<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/functions.php';
require_once __DIR__ . '/../../includes/auth.php';
if (session_status() === PHP_SESSION_NONE) { session_name(SESSION_NAME); session_start(); }
if (!isLoggedIn()) { header('Location: ' . APP_URL . '/login.php'); exit; }
$db = getDB();
$stmt = $db->query("SELECT full_name, username, email, phone, work_phone, private_phone, department, position, status FROM users ORDER BY full_name");
$users = $stmt->fetchAll();
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="korisnici_' . date('Y-m-d') . '.csv"');
echo "\xEF\xBB\xBF";
$output = fopen('php://output', 'w');
fputcsv($output, ['Ime i prezime', 'Username', 'Email', 'Telefon', 'Služ. mob.', 'Priv. mob.', 'Odjel', 'Pozicija', 'Status'], ';');
foreach ($users as $user) {
    fputcsv($output, [$user['full_name'], $user['username'], $user['email'], $user['phone'], $user['work_phone'], $user['private_phone'], $user['department'], $user['position'], $user['status']], ';');
}
fclose($output);
exit;
