<?php
$pageTitle = 'Korisnici - IT Inventory';
$currentPage = 'users';

require_once __DIR__ . '/../../includes/header.php';
requireLogin();

$db = getDB();
$search = $_GET['search'] ?? '';
$status = $_GET['status'] ?? '';
$service = $_GET['service'] ?? '';

$where = [];
$params = [];

if ($search) {
    $where[] = "(username LIKE ? OR full_name LIKE ? OR email LIKE ? OR department LIKE ?)";
    $s = "%{$search}%";
    $params = array_merge($params, [$s, $s, $s, $s]);
}
if ($status) { $where[] = "status = ?"; $params[] = $status; }
if ($service === 'ad') { $where[] = "ad_enabled = 1"; }
if ($service === 'zimbra') { $where[] = "zimbra_enabled = 1"; }
if ($service === 'nextcloud') { $where[] = "nextcloud_enabled = 1"; }

$whereClause = $where ? 'WHERE ' . implode(' AND ', $where) : '';
$stmt = $db->prepare("SELECT * FROM users {$whereClause} ORDER BY full_name");
$stmt->execute($params);
$users = $stmt->fetchAll();
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4><i class="bi bi-people me-2"></i>Korisnici</h4>
    <div>
        <a href="print.php" class="btn btn-outline-info"><i class="bi bi-printer me-1"></i>Print centar</a>
        <a href="export.php" class="btn btn-outline-success"><i class="bi bi-file-earmark-excel me-1"></i>Quick CSV</a>
        <a href="add.php" class="btn btn-primary"><i class="bi bi-plus-lg me-1"></i>Novi korisnik</a>
    </div>
</div>

<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-4">
                <div class="search-box">
                    <i class="bi bi-search"></i>
                    <input type="text" name="search" class="form-control" placeholder="Pretraži..." value="<?= clean($search) ?>">
                </div>
            </div>
            <div class="col-md-3">
                <select name="service" class="form-select">
                    <option value="">Svi servisi</option>
                    <option value="ad" <?= $service === 'ad' ? 'selected' : '' ?>>Active Directory</option>
                    <option value="zimbra" <?= $service === 'zimbra' ? 'selected' : '' ?>>Zimbra</option>
                    <option value="nextcloud" <?= $service === 'nextcloud' ? 'selected' : '' ?>>Nextcloud</option>
                </select>
            </div>
            <div class="col-md-3">
                <select name="status" class="form-select">
                    <option value="">Svi statusi</option>
                    <option value="active" <?= $status === 'active' ? 'selected' : '' ?>>Active</option>
                    <option value="disabled" <?= $status === 'disabled' ? 'selected' : '' ?>>Disabled</option>
                    <option value="suspended" <?= $status === 'suspended' ? 'selected' : '' ?>>Suspended</option>
                </select>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-outline-secondary w-100">Filtriraj</button>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>Korisnik</th>
                    <th>Odjel</th>
                    <th>Email</th>
                    <th>Telefon</th>
                    <th class="text-center">AD</th>
                    <th class="text-center">Zimbra</th>
                    <th class="text-center">NC</th>
                    <th>Status</th>
                    <th class="text-end">Akcije</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($users)): ?>
                <tr><td colspan="9" class="text-center text-muted py-4"><i class="bi bi-inbox display-6 d-block mb-2"></i>Nema korisnika</td></tr>
                <?php else: ?>
                <?php foreach ($users as $u): ?>
                <tr>
                    <td>
                        <a href="view.php?id=<?= $u['id'] ?>" class="fw-bold text-decoration-none"><?= clean($u['full_name']) ?></a>
                        <br><small class="text-muted"><?= clean($u['username']) ?></small>
                    </td>
                    <td><?= clean($u['department']) ?: '-' ?></td>
                    <td><?= clean($u['email']) ?: '-' ?></td>
                    <td><?= clean($u['phone']) ?: clean($u['work_phone']) ?: '-' ?></td>
                    <td class="text-center"><?= $u['ad_enabled'] ? '<i class="bi bi-check-circle text-success"></i>' : '<i class="bi bi-x-circle text-muted"></i>' ?></td>
                    <td class="text-center"><?= $u['zimbra_enabled'] ? '<i class="bi bi-check-circle text-success"></i>' : '<i class="bi bi-x-circle text-muted"></i>' ?></td>
                    <td class="text-center"><?= $u['nextcloud_enabled'] ? '<i class="bi bi-check-circle text-success"></i>' : '<i class="bi bi-x-circle text-muted"></i>' ?></td>
                    <td><?= statusBadge($u['status']) ?></td>
                    <td class="text-end">
                        <a href="view.php?id=<?= $u['id'] ?>" class="btn btn-sm btn-outline-primary" title="Pregled"><i class="bi bi-eye"></i></a>
                        <a href="credential-sheet.php?id=<?= $u['id'] ?>" class="btn btn-sm btn-outline-info" target="_blank" title="Credential Sheet"><i class="bi bi-file-text"></i></a>
                        <a href="edit.php?id=<?= $u['id'] ?>" class="btn btn-sm btn-outline-secondary" title="Uredi"><i class="bi bi-pencil"></i></a>
                        <a href="delete.php?id=<?= $u['id'] ?>" class="btn btn-sm btn-outline-danger" data-confirm="Obrisati korisnika?" title="Obriši"><i class="bi bi-trash"></i></a>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
