<?php
require_once __DIR__ . '/../../config.php';
require_once __DIR__ . '/../../includes/functions.php';
require_once __DIR__ . '/../../includes/auth.php';

if (session_status() === PHP_SESSION_NONE) {
    session_name(SESSION_NAME);
    session_start();
}

if (!isLoggedIn()) {
    header('Location: ' . APP_URL . '/login.php');
    exit;
}

$db = getDB();

// Dohvati sve odjele za filter
$departments = $db->query("SELECT DISTINCT department FROM users WHERE department IS NOT NULL AND department != '' ORDER BY department")->fetchAll(PDO::FETCH_COLUMN);

// Ako je POST, generiraj ispis
$showPreview = false;
$users = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $showPreview = true;
    
    // Filteri
    $statusFilter = $_POST['status'] ?? '';
    $deptFilter = $_POST['department'] ?? '';
    $serviceFilter = $_POST['service'] ?? '';
    
    $where = [];
    $params = [];
    
    if ($statusFilter) { $where[] = "u.status = ?"; $params[] = $statusFilter; }
    if ($deptFilter) { $where[] = "u.department = ?"; $params[] = $deptFilter; }
    if ($serviceFilter === 'ad') { $where[] = "u.ad_enabled = 1"; }
    if ($serviceFilter === 'zimbra') { $where[] = "u.zimbra_enabled = 1"; }
    if ($serviceFilter === 'nextcloud') { $where[] = "u.nextcloud_enabled = 1"; }
    
    $whereClause = $where ? 'WHERE ' . implode(' AND ', $where) : '';
    
    $sql = "SELECT u.*, 
            (SELECT GROUP_CONCAT(CONCAT(name, ' (', COALESCE(ip_address,''), ')') SEPARATOR ', ') FROM pcs WHERE user_id = u.id) as pcs,
            (SELECT GROUP_CONCAT(CONCAT(name, ' (', COALESCE(ip_address,''), ')') SEPARATOR ', ') FROM laptops WHERE user_id = u.id) as laptops,
            (SELECT GROUP_CONCAT(CONCAT(name, ' (', COALESCE(phone_number,''), ')') SEPARATOR ', ') FROM tablets WHERE user_id = u.id) as tablets,
            (SELECT GROUP_CONCAT(CONCAT(name, ' (', COALESCE(phone_number,''), ')') SEPARATOR ', ') FROM phones WHERE user_id = u.id) as phones
            FROM users u {$whereClause} ORDER BY u.full_name";
    
    $stmt = $db->prepare($sql);
    $stmt->execute($params);
    $users = $stmt->fetchAll();
    
    // Odabrane kolone
    $columns = $_POST['columns'] ?? [];
}

// Ako je CSV export
if (isset($_POST['export_csv']) && $showPreview) {
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename="korisnici_' . date('Y-m-d') . '.csv"');
    echo "\xEF\xBB\xBF";
    $output = fopen('php://output', 'w');
    
    $headers = [];
    if (in_array('name', $columns)) $headers[] = 'Ime i prezime';
    if (in_array('username', $columns)) $headers[] = 'Username';
    if (in_array('email', $columns)) $headers[] = 'Email';
    if (in_array('phone', $columns)) $headers[] = 'Telefon';
    if (in_array('work_phone', $columns)) $headers[] = 'Služ. mob.';
    if (in_array('private_phone', $columns)) $headers[] = 'Priv. mob.';
    if (in_array('department', $columns)) $headers[] = 'Odjel';
    if (in_array('position', $columns)) $headers[] = 'Pozicija';
    if (in_array('ad_password', $columns)) $headers[] = 'AD Password';
    if (in_array('zimbra_password', $columns)) $headers[] = 'Zimbra Password';
    if (in_array('nextcloud_password', $columns)) $headers[] = 'NC Password';
    if (in_array('pc', $columns)) $headers[] = 'PC';
    if (in_array('laptop', $columns)) $headers[] = 'Laptop';
    if (in_array('tablet', $columns)) $headers[] = 'Tablet';
    if (in_array('mobitel', $columns)) $headers[] = 'Mobitel';
    
    fputcsv($output, $headers, ';');
    
    foreach ($users as $u) {
        $row = [];
        if (in_array('name', $columns)) $row[] = $u['full_name'];
        if (in_array('username', $columns)) $row[] = $u['username'];
        if (in_array('email', $columns)) $row[] = $u['email'];
        if (in_array('phone', $columns)) $row[] = $u['phone'];
        if (in_array('work_phone', $columns)) $row[] = $u['work_phone'];
        if (in_array('private_phone', $columns)) $row[] = $u['private_phone'];
        if (in_array('department', $columns)) $row[] = $u['department'];
        if (in_array('position', $columns)) $row[] = $u['position'];
        if (in_array('ad_password', $columns)) $row[] = $u['ad_password'];
        if (in_array('zimbra_password', $columns)) $row[] = $u['zimbra_password'];
        if (in_array('nextcloud_password', $columns)) $row[] = $u['nextcloud_password'];
        if (in_array('pc', $columns)) $row[] = $u['pcs'];
        if (in_array('laptop', $columns)) $row[] = $u['laptops'];
        if (in_array('tablet', $columns)) $row[] = $u['tablets'];
        if (in_array('mobitel', $columns)) $row[] = $u['phones'];
        fputcsv($output, $row, ';');
    }
    fclose($output);
    exit;
}

$pageTitle = 'Print centar - IT Inventory';
$currentPage = 'users';
require_once __DIR__ . '/../../includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4><i class="bi bi-printer me-2"></i>Print centar - Korisnici</h4>
    <a href="index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-1"></i>Natrag</a>
</div>

<form method="POST" id="printForm">
<div class="row">
    <div class="col-md-4">
        <div class="card mb-4">
            <div class="card-header bg-white"><h6 class="mb-0">Filteri</h6></div>
            <div class="card-body">
                <div class="mb-3">
                    <label class="form-label">Status</label>
                    <select name="status" class="form-select">
                        <option value="">Svi</option>
                        <option value="active" <?= ($_POST['status'] ?? '') === 'active' ? 'selected' : '' ?>>Active</option>
                        <option value="disabled" <?= ($_POST['status'] ?? '') === 'disabled' ? 'selected' : '' ?>>Disabled</option>
                        <option value="suspended" <?= ($_POST['status'] ?? '') === 'suspended' ? 'selected' : '' ?>>Suspended</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">Odjel</label>
                    <select name="department" class="form-select">
                        <option value="">Svi</option>
                        <?php foreach ($departments as $dept): ?>
                        <option value="<?= clean($dept) ?>" <?= ($_POST['department'] ?? '') === $dept ? 'selected' : '' ?>><?= clean($dept) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">Servis</label>
                    <select name="service" class="form-select">
                        <option value="">Svi</option>
                        <option value="ad" <?= ($_POST['service'] ?? '') === 'ad' ? 'selected' : '' ?>>Samo AD</option>
                        <option value="zimbra" <?= ($_POST['service'] ?? '') === 'zimbra' ? 'selected' : '' ?>>Samo Zimbra</option>
                        <option value="nextcloud" <?= ($_POST['service'] ?? '') === 'nextcloud' ? 'selected' : '' ?>>Samo Nextcloud</option>
                    </select>
                </div>
            </div>
        </div>
        
        <div class="card mb-4">
            <div class="card-header bg-white"><h6 class="mb-0">Kolone za prikaz</h6></div>
            <div class="card-body">
                <div class="mb-2"><strong>Osnovni podaci:</strong></div>
                <div class="form-check"><input type="checkbox" name="columns[]" value="name" class="form-check-input" id="col_name" <?= in_array('name', $_POST['columns'] ?? ['name']) ? 'checked' : '' ?>><label class="form-check-label" for="col_name">Ime i prezime</label></div>
                <div class="form-check"><input type="checkbox" name="columns[]" value="username" class="form-check-input" id="col_user" <?= in_array('username', $_POST['columns'] ?? ['username']) ? 'checked' : '' ?>><label class="form-check-label" for="col_user">Username</label></div>
                <div class="form-check"><input type="checkbox" name="columns[]" value="email" class="form-check-input" id="col_email" <?= in_array('email', $_POST['columns'] ?? ['email']) ? 'checked' : '' ?>><label class="form-check-label" for="col_email">Email</label></div>
                <div class="form-check"><input type="checkbox" name="columns[]" value="department" class="form-check-input" id="col_dept" <?= in_array('department', $_POST['columns'] ?? []) ? 'checked' : '' ?>><label class="form-check-label" for="col_dept">Odjel</label></div>
                <div class="form-check"><input type="checkbox" name="columns[]" value="position" class="form-check-input" id="col_pos" <?= in_array('position', $_POST['columns'] ?? []) ? 'checked' : '' ?>><label class="form-check-label" for="col_pos">Pozicija</label></div>
                
                <div class="mb-2 mt-3"><strong>Telefoni:</strong></div>
                <div class="form-check"><input type="checkbox" name="columns[]" value="phone" class="form-check-input" id="col_phone" <?= in_array('phone', $_POST['columns'] ?? ['phone']) ? 'checked' : '' ?>><label class="form-check-label" for="col_phone">Telefon (glavni)</label></div>
                <div class="form-check"><input type="checkbox" name="columns[]" value="work_phone" class="form-check-input" id="col_wphone" <?= in_array('work_phone', $_POST['columns'] ?? []) ? 'checked' : '' ?>><label class="form-check-label" for="col_wphone">Službeni mob.</label></div>
                <div class="form-check"><input type="checkbox" name="columns[]" value="private_phone" class="form-check-input" id="col_pphone" <?= in_array('private_phone', $_POST['columns'] ?? []) ? 'checked' : '' ?>><label class="form-check-label" for="col_pphone">Privatni mob.</label></div>
                
                <div class="mb-2 mt-3"><strong>Lozinke:</strong></div>
                <div class="form-check"><input type="checkbox" name="columns[]" value="ad_password" class="form-check-input" id="col_adp" <?= in_array('ad_password', $_POST['columns'] ?? []) ? 'checked' : '' ?>><label class="form-check-label" for="col_adp">AD Password</label></div>
                <div class="form-check"><input type="checkbox" name="columns[]" value="zimbra_password" class="form-check-input" id="col_zp" <?= in_array('zimbra_password', $_POST['columns'] ?? []) ? 'checked' : '' ?>><label class="form-check-label" for="col_zp">Zimbra Password</label></div>
                <div class="form-check"><input type="checkbox" name="columns[]" value="nextcloud_password" class="form-check-input" id="col_ncp" <?= in_array('nextcloud_password', $_POST['columns'] ?? []) ? 'checked' : '' ?>><label class="form-check-label" for="col_ncp">Nextcloud Password</label></div>
                
                <div class="mb-2 mt-3"><strong>Uređaji:</strong></div>
                <div class="form-check"><input type="checkbox" name="columns[]" value="pc" class="form-check-input" id="col_pc" <?= in_array('pc', $_POST['columns'] ?? []) ? 'checked' : '' ?>><label class="form-check-label" for="col_pc">PC</label></div>
                <div class="form-check"><input type="checkbox" name="columns[]" value="laptop" class="form-check-input" id="col_laptop" <?= in_array('laptop', $_POST['columns'] ?? []) ? 'checked' : '' ?>><label class="form-check-label" for="col_laptop">Laptop</label></div>
                <div class="form-check"><input type="checkbox" name="columns[]" value="tablet" class="form-check-input" id="col_tablet" <?= in_array('tablet', $_POST['columns'] ?? []) ? 'checked' : '' ?>><label class="form-check-label" for="col_tablet">Tablet</label></div>
                <div class="form-check"><input type="checkbox" name="columns[]" value="mobitel" class="form-check-input" id="col_mob" <?= in_array('mobitel', $_POST['columns'] ?? []) ? 'checked' : '' ?>><label class="form-check-label" for="col_mob">Mobitel</label></div>
            </div>
        </div>
        
        <div class="d-grid gap-2">
            <button type="submit" class="btn btn-primary"><i class="bi bi-eye me-1"></i>Pregled</button>
            <button type="submit" name="export_csv" value="1" class="btn btn-success"><i class="bi bi-file-earmark-excel me-1"></i>Export CSV</button>
        </div>
    </div>
    
    <div class="col-md-8">
        <?php if ($showPreview && !isset($_POST['export_csv'])): ?>
        <div class="card">
            <div class="card-header bg-white d-flex justify-content-between align-items-center">
                <h6 class="mb-0">Pregled (<?= count($users) ?> korisnika)</h6>
                <button type="button" class="btn btn-sm btn-outline-primary" onclick="printTable()"><i class="bi bi-printer me-1"></i>Ispiši</button>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-sm table-striped mb-0" id="printTable">
                        <thead>
                            <tr>
                                <?php if (in_array('name', $columns)): ?><th>Ime i prezime</th><?php endif; ?>
                                <?php if (in_array('username', $columns)): ?><th>Username</th><?php endif; ?>
                                <?php if (in_array('email', $columns)): ?><th>Email</th><?php endif; ?>
                                <?php if (in_array('phone', $columns)): ?><th>Telefon</th><?php endif; ?>
                                <?php if (in_array('work_phone', $columns)): ?><th>Služ. mob.</th><?php endif; ?>
                                <?php if (in_array('private_phone', $columns)): ?><th>Priv. mob.</th><?php endif; ?>
                                <?php if (in_array('department', $columns)): ?><th>Odjel</th><?php endif; ?>
                                <?php if (in_array('position', $columns)): ?><th>Pozicija</th><?php endif; ?>
                                <?php if (in_array('ad_password', $columns)): ?><th>AD Pass</th><?php endif; ?>
                                <?php if (in_array('zimbra_password', $columns)): ?><th>Zimbra Pass</th><?php endif; ?>
                                <?php if (in_array('nextcloud_password', $columns)): ?><th>NC Pass</th><?php endif; ?>
                                <?php if (in_array('pc', $columns)): ?><th>PC</th><?php endif; ?>
                                <?php if (in_array('laptop', $columns)): ?><th>Laptop</th><?php endif; ?>
                                <?php if (in_array('tablet', $columns)): ?><th>Tablet</th><?php endif; ?>
                                <?php if (in_array('mobitel', $columns)): ?><th>Mobitel</th><?php endif; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($users as $u): ?>
                            <tr>
                                <?php if (in_array('name', $columns)): ?><td><?= clean($u['full_name']) ?></td><?php endif; ?>
                                <?php if (in_array('username', $columns)): ?><td><?= clean($u['username']) ?></td><?php endif; ?>
                                <?php if (in_array('email', $columns)): ?><td><?= clean($u['email']) ?></td><?php endif; ?>
                                <?php if (in_array('phone', $columns)): ?><td><?= clean($u['phone']) ?></td><?php endif; ?>
                                <?php if (in_array('work_phone', $columns)): ?><td><?= clean($u['work_phone']) ?></td><?php endif; ?>
                                <?php if (in_array('private_phone', $columns)): ?><td><?= clean($u['private_phone']) ?></td><?php endif; ?>
                                <?php if (in_array('department', $columns)): ?><td><?= clean($u['department']) ?></td><?php endif; ?>
                                <?php if (in_array('position', $columns)): ?><td><?= clean($u['position']) ?></td><?php endif; ?>
                                <?php if (in_array('ad_password', $columns)): ?><td><small><?= clean($u['ad_password']) ?></small></td><?php endif; ?>
                                <?php if (in_array('zimbra_password', $columns)): ?><td><small><?= clean($u['zimbra_password']) ?></small></td><?php endif; ?>
                                <?php if (in_array('nextcloud_password', $columns)): ?><td><small><?= clean($u['nextcloud_password']) ?></small></td><?php endif; ?>
                                <?php if (in_array('pc', $columns)): ?><td><small><?= clean($u['pcs']) ?></small></td><?php endif; ?>
                                <?php if (in_array('laptop', $columns)): ?><td><small><?= clean($u['laptops']) ?></small></td><?php endif; ?>
                                <?php if (in_array('tablet', $columns)): ?><td><small><?= clean($u['tablets']) ?></small></td><?php endif; ?>
                                <?php if (in_array('mobitel', $columns)): ?><td><small><?= clean($u['phones']) ?></small></td><?php endif; ?>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <?php else: ?>
        <div class="card">
            <div class="card-body text-center text-muted py-5">
                <i class="bi bi-printer display-1"></i>
                <p class="mt-3">Odaberi filtere i kolone, pa klikni "Pregled" za generiranje tablice.</p>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
</form>

<script>
function printTable() {
    var printContents = document.getElementById('printTable').outerHTML;
    var originalContents = document.body.innerHTML;
    
    document.body.innerHTML = `
        <html>
        <head>
            <title>Lista korisnika</title>
            <style>
                body { font-family: Arial, sans-serif; font-size: 10pt; }
                table { width: 100%; border-collapse: collapse; }
                th, td { border: 1px solid #ddd; padding: 6px; text-align: left; }
                th { background: #f5f5f5; font-weight: bold; }
                @page { size: landscape; margin: 10mm; }
            </style>
        </head>
        <body>
            <h2>Lista korisnika - <?= date('d.m.Y.') ?></h2>
            ${printContents}
        </body>
        </html>
    `;
    
    window.print();
    document.body.innerHTML = originalContents;
    location.reload();
}
</script>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
