<?php
/**
 * IT Inventory - Add/Edit Virtual Machine
 */
$isEdit = isset($_GET['id']);
$pageTitle = ($isEdit ? 'Uredi' : 'Nova') . ' virtualka - IT Inventory';
$currentPage = 'vms';

require_once __DIR__ . '/../../includes/header.php';
requireLogin();

$db = getDB();
$vm = null;
$errors = [];

$servers = $db->query("SELECT id, name FROM servers WHERE status != 'offline' ORDER BY name")->fetchAll();

if ($isEdit) {
    $stmt = $db->prepare("SELECT * FROM virtual_machines WHERE id = ?");
    $stmt->execute([$_GET['id']]);
    $vm = $stmt->fetch();
    if (!$vm) {
        setFlash('error', 'VM nije pronađen.');
        header('Location: index.php');
        exit;
    }
}

if (!$isEdit && isset($_GET['server_id'])) {
    $vm['server_id'] = $_GET['server_id'];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verifyCSRF($_POST['csrf_token'] ?? '')) {
        $errors[] = 'Nevažeći CSRF token.';
    }
    
    $data = [
        'server_id' => (int)($_POST['server_id'] ?? 0),
        'vmid' => (int)($_POST['vmid'] ?? 0) ?: null,
        'name' => trim($_POST['name'] ?? ''),
        'ip_address' => trim($_POST['ip_address'] ?? ''),
        'os' => trim($_POST['os'] ?? ''),
        'cpu_cores' => (int)($_POST['cpu_cores'] ?? 1),
        'ram_gb' => (int)($_POST['ram_gb'] ?? 1),
        'disk_gb' => (int)($_POST['disk_gb'] ?? 10),
        'purpose' => trim($_POST['purpose'] ?? ''),
        'status' => $_POST['status'] ?? 'running',
        'backup_enabled' => isset($_POST['backup_enabled']) ? 1 : 0,
        'backup_schedule' => trim($_POST['backup_schedule'] ?? ''),
        'notes' => trim($_POST['notes'] ?? '')
    ];
    
    if (empty($data['name'])) $errors[] = 'Naziv je obavezan.';
    if (empty($data['server_id'])) $errors[] = 'Server je obavezan.';
    if ($data['ip_address'] && !filter_var($data['ip_address'], FILTER_VALIDATE_IP)) {
        $errors[] = 'IP adresa nije ispravna.';
    }
    
    if (empty($errors)) {
        try {
            if ($isEdit) {
                $oldValues = $vm;
                $stmt = $db->prepare("UPDATE virtual_machines SET server_id=?, vmid=?, name=?, ip_address=?, os=?, cpu_cores=?, ram_gb=?, disk_gb=?, purpose=?, status=?, backup_enabled=?, backup_schedule=?, notes=? WHERE id=?");
                $stmt->execute([$data['server_id'], $data['vmid'], $data['name'], $data['ip_address'], $data['os'], $data['cpu_cores'], $data['ram_gb'], $data['disk_gb'], $data['purpose'], $data['status'], $data['backup_enabled'], $data['backup_schedule'], $data['notes'], $_GET['id']]);
                logChange('update', 'vm', $_GET['id'], $data['name'], $oldValues, $data);
                setFlash('success', 'VM je uspješno ažuriran.');
            } else {
                $stmt = $db->prepare("INSERT INTO virtual_machines (server_id, vmid, name, ip_address, os, cpu_cores, ram_gb, disk_gb, purpose, status, backup_enabled, backup_schedule, notes) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                $stmt->execute([$data['server_id'], $data['vmid'], $data['name'], $data['ip_address'], $data['os'], $data['cpu_cores'], $data['ram_gb'], $data['disk_gb'], $data['purpose'], $data['status'], $data['backup_enabled'], $data['backup_schedule'], $data['notes']]);
                logChange('create', 'vm', $db->lastInsertId(), $data['name'], null, $data);
                setFlash('success', 'VM je uspješno dodan.');
            }
            header('Location: index.php');
            exit;
        } catch (PDOException $e) {
            $errors[] = 'Greška: ' . $e->getMessage();
        }
    }
    $vm = $data;
}
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4><i class="bi bi-pc-display me-2"></i><?= $isEdit ? 'Uredi VM: ' . clean($vm['name']) : 'Nova virtualna mašina' ?></h4>
    <a href="index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-1"></i>Natrag</a>
</div>

<?php if ($errors): ?>
<div class="alert alert-danger"><ul class="mb-0"><?php foreach ($errors as $e): ?><li><?= clean($e) ?></li><?php endforeach; ?></ul></div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <form method="POST">
            <input type="hidden" name="csrf_token" value="<?= generateCSRF() ?>">
            <div class="row">
                <div class="col-md-6">
                    <h6 class="text-muted mb-3">Osnovni podaci</h6>
                    <div class="mb-3">
                        <label class="form-label required">Server</label>
                        <select name="server_id" class="form-select" required>
                            <option value="">-- Odaberi server --</option>
                            <?php foreach ($servers as $s): ?>
                            <option value="<?= $s['id'] ?>" <?= ($vm['server_id'] ?? '') == $s['id'] ? 'selected' : '' ?>><?= clean($s['name']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="row">
                        <div class="col-4">
                            <div class="mb-3">
                                <label class="form-label">VMID</label>
                                <input type="number" name="vmid" class="form-control" value="<?= (int)($vm['vmid'] ?? 0) ?: '' ?>" min="100">
                            </div>
                        </div>
                        <div class="col-8">
                            <div class="mb-3">
                                <label class="form-label required">Naziv</label>
                                <input type="text" name="name" class="form-control" value="<?= clean($vm['name'] ?? '') ?>" required>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">IP adresa</label>
                        <input type="text" name="ip_address" class="form-control" value="<?= clean($vm['ip_address'] ?? '') ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">OS</label>
                        <input type="text" name="os" class="form-control" value="<?= clean($vm['os'] ?? '') ?>" placeholder="Ubuntu 22.04">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Namjena</label>
                        <input type="text" name="purpose" class="form-control" value="<?= clean($vm['purpose'] ?? '') ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select">
                            <option value="running" <?= ($vm['status'] ?? '') === 'running' ? 'selected' : '' ?>>Running</option>
                            <option value="stopped" <?= ($vm['status'] ?? '') === 'stopped' ? 'selected' : '' ?>>Stopped</option>
                            <option value="suspended" <?= ($vm['status'] ?? '') === 'suspended' ? 'selected' : '' ?>>Suspended</option>
                            <option value="template" <?= ($vm['status'] ?? '') === 'template' ? 'selected' : '' ?>>Template</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-6">
                    <h6 class="text-muted mb-3">Resursi</h6>
                    <div class="row">
                        <div class="col-4 mb-3">
                            <label class="form-label">CPU cores</label>
                            <input type="number" name="cpu_cores" class="form-control" value="<?= (int)($vm['cpu_cores'] ?? 1) ?>" min="1">
                        </div>
                        <div class="col-4 mb-3">
                            <label class="form-label">RAM (GB)</label>
                            <input type="number" name="ram_gb" class="form-control" value="<?= (int)($vm['ram_gb'] ?? 1) ?>" min="1">
                        </div>
                        <div class="col-4 mb-3">
                            <label class="form-label">Disk (GB)</label>
                            <input type="number" name="disk_gb" class="form-control" value="<?= (int)($vm['disk_gb'] ?? 10) ?>" min="1">
                        </div>
                    </div>
                    <h6 class="text-muted mb-3 mt-3">Backup</h6>
                    <div class="mb-3 form-check">
                        <input type="checkbox" name="backup_enabled" class="form-check-input" id="backup" <?= ($vm['backup_enabled'] ?? 0) ? 'checked' : '' ?>>
                        <label class="form-check-label" for="backup">Backup uključen</label>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Backup raspored</label>
                        <input type="text" name="backup_schedule" class="form-control" value="<?= clean($vm['backup_schedule'] ?? '') ?>" placeholder="Svaki dan u 02:00">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Napomene</label>
                        <textarea name="notes" class="form-control" rows="4"><?= clean($vm['notes'] ?? '') ?></textarea>
                    </div>
                </div>
            </div>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary"><i class="bi bi-check-lg me-1"></i><?= $isEdit ? 'Spremi' : 'Dodaj' ?></button>
                <a href="index.php" class="btn btn-outline-secondary">Odustani</a>
            </div>
        </form>
    </div>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
