<?php
require_once __DIR__ . '/../../includes/header.php';
requireLogin();
$db = getDB();

$stmt = $db->prepare("SELECT v.*, s.name as server_name FROM virtual_machines v LEFT JOIN servers s ON v.server_id = s.id WHERE v.id = ?");
$stmt->execute([$_GET['id'] ?? 0]);
$vm = $stmt->fetch();

if (!$vm) { setFlash('error', 'VM nije pronađen.'); header('Location: index.php'); exit; }

$pageTitle = $vm['name'] . ' - IT Inventory';
$currentPage = 'vms';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4><i class="bi bi-pc-display me-2"></i><?= clean($vm['name']) ?> <?= statusBadge($vm['status']) ?></h4>
        <p class="text-muted mb-0">Server: <a href="<?= APP_URL ?>/modules/servers/view.php?id=<?= $vm['server_id'] ?>"><?= clean($vm['server_name']) ?></a></p>
    </div>
    <div>
        <a href="edit.php?id=<?= $vm['id'] ?>" class="btn btn-outline-primary"><i class="bi bi-pencil me-1"></i>Uredi</a>
        <a href="index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-1"></i>Natrag</a>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-white"><h6 class="mb-0">Informacije</h6></div>
            <div class="card-body">
                <table class="table table-sm">
                    <tr><th class="text-muted" style="width:35%">VMID</th><td><code><?= $vm['vmid'] ?: '-' ?></code></td></tr>
                    <tr><th class="text-muted">IP adresa</th><td><?= $vm['ip_address'] ? '<code>' . clean($vm['ip_address']) . '</code>' : '-' ?></td></tr>
                    <tr><th class="text-muted">OS</th><td><?= clean($vm['os']) ?: '-' ?></td></tr>
                    <tr><th class="text-muted">Namjena</th><td><?= clean($vm['purpose']) ?: '-' ?></td></tr>
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-white"><h6 class="mb-0">Resursi & Backup</h6></div>
            <div class="card-body">
                <table class="table table-sm">
                    <tr><th class="text-muted" style="width:35%">CPU</th><td><?= $vm['cpu_cores'] ?> core(s)</td></tr>
                    <tr><th class="text-muted">RAM</th><td><?= formatSize($vm['ram_gb']) ?></td></tr>
                    <tr><th class="text-muted">Disk</th><td><?= formatSize($vm['disk_gb']) ?></td></tr>
                    <tr><th class="text-muted">Backup</th><td><?= $vm['backup_enabled'] ? '<span class="badge bg-success">Da</span>' : '<span class="badge bg-secondary">Ne</span>' ?></td></tr>
                    <tr><th class="text-muted">Raspored</th><td><?= clean($vm['backup_schedule']) ?: '-' ?></td></tr>
                </table>
            </div>
        </div>
    </div>
</div>

<?php if ($vm['notes']): ?>
<div class="card mt-4">
    <div class="card-header bg-white"><h6 class="mb-0">Napomene</h6></div>
    <div class="card-body"><?= nl2br(clean($vm['notes'])) ?></div>
</div>
<?php endif; ?>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
